/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.example;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.parquet.column.ParquetProperties;
import net.snowflake.ingest.internal.apache.parquet.example.data.Group;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetWriter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.api.WriteSupport;
import net.snowflake.ingest.internal.apache.parquet.hadoop.example.GroupWriteSupport;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.CompressionCodecName;
import net.snowflake.ingest.internal.apache.parquet.io.OutputFile;
import net.snowflake.ingest.internal.apache.parquet.schema.MessageType;

public class ExampleParquetWriter
extends ParquetWriter<Group> {
    public static Builder builder(Path file) {
        return new Builder(file);
    }

    public static Builder builder(OutputFile file) {
        return new Builder(file);
    }

    ExampleParquetWriter(Path file, WriteSupport<Group> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        super(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, enableValidation, writerVersion, conf);
    }

    public static class Builder
    extends ParquetWriter.Builder<Group, Builder> {
        private MessageType type = null;
        private Map<String, String> extraMetaData = new HashMap<String, String>();

        private Builder(Path file) {
            super(file);
        }

        private Builder(OutputFile file) {
            super(file);
        }

        public Builder withType(MessageType type) {
            this.type = type;
            return this;
        }

        public Builder withExtraMetaData(Map<String, String> extraMetaData) {
            this.extraMetaData = extraMetaData;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected WriteSupport<Group> getWriteSupport(Configuration conf) {
            return new GroupWriteSupport(this.type, this.extraMetaData);
        }
    }
}

