/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.io.api;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.snowflake.ingest.internal.apache.parquet.io.ParquetEncodingException;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveComparator;

public abstract class Binary
implements Comparable<Binary>,
Serializable {
    protected boolean isBackingBytesReused;
    public static final Binary EMPTY = Binary.fromConstantByteArray(new byte[0]);

    private Binary() {
    }

    public abstract String toStringUsingUTF8();

    public abstract int length();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract void writeTo(DataOutput var1) throws IOException;

    public abstract byte[] getBytes();

    public abstract byte[] getBytesUnsafe();

    public abstract Binary slice(int var1, int var2);

    abstract boolean equals(byte[] var1, int var2, int var3);

    abstract boolean equals(ByteBuffer var1, int var2, int var3);

    abstract boolean equals(Binary var1);

    @Override
    @Deprecated
    public abstract int compareTo(Binary var1);

    abstract int lexicographicCompare(Binary var1);

    abstract int lexicographicCompare(byte[] var1, int var2, int var3);

    abstract int lexicographicCompare(ByteBuffer var1, int var2, int var3);

    public abstract ByteBuffer toByteBuffer();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Binary) {
            return this.equals((Binary)obj);
        }
        return false;
    }

    public String toString() {
        return "Binary{" + this.length() + (this.isBackingBytesReused ? " reused" : " constant") + " bytes, " + Arrays.toString(this.getBytesUnsafe()) + "}";
    }

    public Binary copy() {
        if (this.isBackingBytesReused) {
            return Binary.fromConstantByteArray(this.getBytes());
        }
        return this;
    }

    public boolean isBackingBytesReused() {
        return this.isBackingBytesReused;
    }

    public static Binary fromReusedByteArray(byte[] value, int offset, int length) {
        return new ByteArraySliceBackedBinary(value, offset, length, true);
    }

    public static Binary fromConstantByteArray(byte[] value, int offset, int length) {
        return new ByteArraySliceBackedBinary(value, offset, length, false);
    }

    @Deprecated
    public static Binary fromByteArray(byte[] value, int offset, int length) {
        return Binary.fromReusedByteArray(value, offset, length);
    }

    public static Binary fromReusedByteArray(byte[] value) {
        return new ByteArrayBackedBinary(value, true);
    }

    public static Binary fromConstantByteArray(byte[] value) {
        return new ByteArrayBackedBinary(value, false);
    }

    @Deprecated
    public static Binary fromByteArray(byte[] value) {
        return Binary.fromReusedByteArray(value);
    }

    public static Binary fromReusedByteBuffer(ByteBuffer value, int offset, int length) {
        return new ByteBufferBackedBinary(value, offset, length, true);
    }

    public static Binary fromConstantByteBuffer(ByteBuffer value, int offset, int length) {
        return new ByteBufferBackedBinary(value, offset, length, false);
    }

    public static Binary fromReusedByteBuffer(ByteBuffer value) {
        return new ByteBufferBackedBinary(value, true);
    }

    public static Binary fromConstantByteBuffer(ByteBuffer value) {
        return new ByteBufferBackedBinary(value, false);
    }

    @Deprecated
    public static Binary fromByteBuffer(ByteBuffer value) {
        return Binary.fromReusedByteBuffer(value);
    }

    public static Binary fromString(String value) {
        return new FromStringBinary(value);
    }

    public static Binary fromCharSequence(CharSequence value) {
        return new FromCharSequenceBinary(value);
    }

    public static int lexicographicCompare(Binary one, Binary other) {
        return one.lexicographicCompare(other);
    }

    private static final int hashCode(byte[] array, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            result = 31 * result + b;
        }
        return result;
    }

    private static final int hashCode(ByteBuffer buf, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            byte b = buf.get(i);
            result = 31 * result + b;
        }
        return result;
    }

    private static final boolean equals(ByteBuffer buf1, int offset1, int length1, ByteBuffer buf2, int offset2, int length2) {
        if (buf1 == null && buf2 == null) {
            return true;
        }
        if (buf1 == null || buf2 == null) {
            return false;
        }
        if (length1 != length2) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            if (buf1.get(i + offset1) == buf2.get(i + offset2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean equals(byte[] array1, int offset1, int length1, ByteBuffer buf, int offset2, int length2) {
        if (array1 == null && buf == null) {
            return true;
        }
        if (array1 == null || buf == null) {
            return false;
        }
        if (length1 != length2) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            if (array1[i + offset1] == buf.get(i + offset2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean equals(byte[] array1, int offset1, int length1, byte[] array2, int offset2, int length2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (length1 != length2) {
            return false;
        }
        if (array1 == array2 && offset1 == offset2) {
            return true;
        }
        for (int i = 0; i < length1; ++i) {
            if (array1[i + offset1] == array2[i + offset2]) continue;
            return false;
        }
        return true;
    }

    private static final int lexicographicCompare(byte[] array1, int offset1, int length1, byte[] array2, int offset2, int length2) {
        if (array1 == null && array2 == null) {
            return 0;
        }
        if (array1 == null || array2 == null) {
            return array1 != null ? 1 : -1;
        }
        int minLen = Math.min(length1, length2);
        for (int i = 0; i < minLen; ++i) {
            int res = Binary.unsignedCompare(array1[i + offset1], array2[i + offset2]);
            if (res == 0) continue;
            return res;
        }
        return length1 - length2;
    }

    private static final int lexicographicCompare(byte[] array, int offset1, int length1, ByteBuffer buffer, int offset2, int length2) {
        if (array == null && buffer == null) {
            return 0;
        }
        if (array == null || buffer == null) {
            return array != null ? 1 : -1;
        }
        int minLen = Math.min(length1, length2);
        for (int i = 0; i < minLen; ++i) {
            int res = Binary.unsignedCompare(array[i + offset1], buffer.get(i + offset2));
            if (res == 0) continue;
            return res;
        }
        return length1 - length2;
    }

    private static final int lexicographicCompare(ByteBuffer buffer1, int offset1, int length1, ByteBuffer buffer2, int offset2, int length2) {
        if (buffer1 == null && buffer2 == null) {
            return 0;
        }
        if (buffer1 == null || buffer2 == null) {
            return buffer1 != null ? 1 : -1;
        }
        int minLen = Math.min(length1, length2);
        for (int i = 0; i < minLen; ++i) {
            int res = Binary.unsignedCompare(buffer1.get(i + offset1), buffer2.get(i + offset2));
            if (res == 0) continue;
            return res;
        }
        return length1 - length2;
    }

    private static int unsignedCompare(byte b1, byte b2) {
        return Binary.toUnsigned(b1) - Binary.toUnsigned(b2);
    }

    private static final int toUnsigned(byte b) {
        return b & 0xFF;
    }

    private static class ByteBufferBackedBinary
    extends Binary {
        private ByteBuffer value;
        private transient byte[] cachedBytes;
        private int offset;
        private int length;

        public ByteBufferBackedBinary(ByteBuffer value, boolean isBackingBytesReused) {
            this.value = value;
            this.offset = value.position();
            this.length = value.remaining();
            this.isBackingBytesReused = isBackingBytesReused;
        }

        public ByteBufferBackedBinary(ByteBuffer value, int offset, int length, boolean isBackingBytesReused) {
            this.value = value;
            this.offset = offset;
            this.length = length;
            this.isBackingBytesReused = isBackingBytesReused;
        }

        @Override
        public String toStringUsingUTF8() {
            String ret;
            if (this.value.hasArray()) {
                ret = new String(this.value.array(), this.value.arrayOffset() + this.offset, this.length, StandardCharsets.UTF_8);
            } else {
                int limit = this.value.limit();
                this.value.limit(this.offset + this.length);
                int position = this.value.position();
                this.value.position(this.offset);
                ret = StandardCharsets.UTF_8.decode(this.value).toString();
                this.value.limit(limit);
                this.value.position(position);
            }
            return ret;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            if (this.value.hasArray()) {
                out.write(this.value.array(), this.value.arrayOffset() + this.offset, this.length);
            } else {
                out.write(this.getBytesUnsafe(), 0, this.length);
            }
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[this.length];
            int limit = this.value.limit();
            this.value.limit(this.offset + this.length);
            int position = this.value.position();
            this.value.position(this.offset);
            this.value.get(bytes);
            this.value.limit(limit);
            this.value.position(position);
            if (!this.isBackingBytesReused) {
                this.cachedBytes = bytes;
            }
            return bytes;
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.cachedBytes != null ? this.cachedBytes : this.getBytes();
        }

        @Override
        public Binary slice(int start, int length) {
            return Binary.fromConstantByteArray(this.getBytesUnsafe(), start, length);
        }

        public int hashCode() {
            if (this.value.hasArray()) {
                return Binary.hashCode(this.value.array(), this.value.arrayOffset() + this.offset, this.length);
            }
            return Binary.hashCode(this.value, this.offset, this.length);
        }

        @Override
        boolean equals(Binary other) {
            if (this.value.hasArray()) {
                return other.equals(this.value.array(), this.value.arrayOffset() + this.offset, this.length);
            }
            return other.equals(this.value, this.offset, this.length);
        }

        @Override
        boolean equals(byte[] other, int otherOffset, int otherLength) {
            if (this.value.hasArray()) {
                return Binary.equals(this.value.array(), this.value.arrayOffset() + this.offset, this.length, other, otherOffset, otherLength);
            }
            return Binary.equals(other, otherOffset, otherLength, this.value, this.offset, this.length);
        }

        @Override
        boolean equals(ByteBuffer otherBytes, int otherOffset, int otherLength) {
            return Binary.equals(this.value, 0, this.length, otherBytes, otherOffset, otherLength);
        }

        @Override
        public int compareTo(Binary other) {
            return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR.compare(this, other);
        }

        @Override
        int lexicographicCompare(Binary other) {
            if (this.value.hasArray()) {
                return -other.lexicographicCompare(this.value.array(), this.value.arrayOffset() + this.offset, this.length);
            }
            return -other.lexicographicCompare(this.value, this.offset, this.length);
        }

        @Override
        int lexicographicCompare(byte[] other, int otherOffset, int otherLength) {
            if (this.value.hasArray()) {
                return Binary.lexicographicCompare(this.value.array(), this.value.arrayOffset() + this.offset, this.length, other, otherOffset, otherLength);
            }
            return -Binary.lexicographicCompare(other, otherOffset, otherLength, this.value, this.offset, this.length);
        }

        @Override
        int lexicographicCompare(ByteBuffer other, int otherOffset, int otherLength) {
            return Binary.lexicographicCompare(this.value, this.offset, this.length, other, otherOffset, otherLength);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            ByteBuffer ret = this.value.duplicate();
            ret.position(this.offset);
            ret.limit(this.offset + this.length);
            return ret;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.write(this.getBytesUnsafe());
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            byte[] bytes = this.getBytesUnsafe();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes, 0, length);
            this.value = ByteBuffer.wrap(bytes);
            this.offset = 0;
            this.length = length;
        }

        private void readObjectNoData() throws ObjectStreamException {
            this.value = ByteBuffer.wrap(new byte[0]);
        }
    }

    private static class ByteArrayBackedBinary
    extends Binary {
        private final byte[] value;

        public ByteArrayBackedBinary(byte[] value, boolean isBackingBytesReused) {
            this.value = value;
            this.isBackingBytesReused = isBackingBytesReused;
        }

        @Override
        public String toStringUsingUTF8() {
            return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(this.value)).toString();
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.value);
        }

        @Override
        public byte[] getBytes() {
            return Arrays.copyOfRange(this.value, 0, this.value.length);
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.value;
        }

        @Override
        public Binary slice(int start, int length) {
            if (this.isBackingBytesReused) {
                return Binary.fromReusedByteArray(this.value, start, length);
            }
            return Binary.fromConstantByteArray(this.value, start, length);
        }

        public int hashCode() {
            return Binary.hashCode(this.value, 0, this.value.length);
        }

        @Override
        boolean equals(Binary other) {
            return other.equals(this.value, 0, this.value.length);
        }

        @Override
        boolean equals(byte[] other, int otherOffset, int otherLength) {
            return Binary.equals(this.value, 0, this.value.length, other, otherOffset, otherLength);
        }

        @Override
        boolean equals(ByteBuffer bytes, int otherOffset, int otherLength) {
            return Binary.equals(this.value, 0, this.value.length, bytes, otherOffset, otherLength);
        }

        @Override
        public int compareTo(Binary other) {
            return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR.compare(this, other);
        }

        @Override
        int lexicographicCompare(Binary other) {
            return -other.lexicographicCompare(this.value, 0, this.value.length);
        }

        @Override
        int lexicographicCompare(byte[] other, int otherOffset, int otherLength) {
            return Binary.lexicographicCompare(this.value, 0, this.value.length, other, otherOffset, otherLength);
        }

        @Override
        int lexicographicCompare(ByteBuffer other, int otherOffset, int otherLength) {
            return Binary.lexicographicCompare(this.value, 0, this.value.length, other, otherOffset, otherLength);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.value);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.write(this.value);
        }
    }

    private static class FromCharSequenceBinary
    extends ByteBufferBackedBinary {
        private static final ThreadLocal<CharsetEncoder> ENCODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);

        public FromCharSequenceBinary(CharSequence value) {
            super(FromCharSequenceBinary.encodeUTF8(value), false);
        }

        @Override
        public String toString() {
            return "Binary{\"" + this.toStringUsingUTF8() + "\"}";
        }

        private static ByteBuffer encodeUTF8(CharSequence value) {
            try {
                return ENCODER.get().encode(CharBuffer.wrap(value));
            }
            catch (CharacterCodingException e) {
                throw new ParquetEncodingException("UTF-8 not supported.", e);
            }
        }
    }

    private static class FromStringBinary
    extends ByteBufferBackedBinary {
        public FromStringBinary(String value) {
            super(FromStringBinary.encodeUTF8(value), false);
        }

        @Override
        public String toString() {
            return "Binary{\"" + this.toStringUsingUTF8() + "\"}";
        }

        private static ByteBuffer encodeUTF8(String value) {
            return ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class ByteArraySliceBackedBinary
    extends Binary {
        private final byte[] value;
        private final int offset;
        private final int length;

        public ByteArraySliceBackedBinary(byte[] value, int offset, int length, boolean isBackingBytesReused) {
            this.value = value;
            this.offset = offset;
            this.length = length;
            this.isBackingBytesReused = isBackingBytesReused;
        }

        @Override
        public String toStringUsingUTF8() {
            return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(this.value, this.offset, this.length)).toString();
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.value, this.offset, this.length);
        }

        @Override
        public byte[] getBytes() {
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.length);
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.getBytes();
        }

        @Override
        public Binary slice(int start, int length) {
            if (this.isBackingBytesReused) {
                return Binary.fromReusedByteArray(this.value, this.offset + start, length);
            }
            return Binary.fromConstantByteArray(this.value, this.offset + start, length);
        }

        public int hashCode() {
            return Binary.hashCode(this.value, this.offset, this.length);
        }

        @Override
        boolean equals(Binary other) {
            return other.equals(this.value, this.offset, this.length);
        }

        @Override
        boolean equals(byte[] other, int otherOffset, int otherLength) {
            return Binary.equals(this.value, this.offset, this.length, other, otherOffset, otherLength);
        }

        @Override
        boolean equals(ByteBuffer bytes, int otherOffset, int otherLength) {
            return Binary.equals(this.value, this.offset, this.length, bytes, otherOffset, otherLength);
        }

        @Override
        public int compareTo(Binary other) {
            return PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR.compare(this, other);
        }

        @Override
        int lexicographicCompare(Binary other) {
            return -other.lexicographicCompare(this.value, this.offset, this.length);
        }

        @Override
        int lexicographicCompare(byte[] other, int otherOffset, int otherLength) {
            return Binary.lexicographicCompare(this.value, this.offset, this.length, other, otherOffset, otherLength);
        }

        @Override
        int lexicographicCompare(ByteBuffer other, int otherOffset, int otherLength) {
            return Binary.lexicographicCompare(this.value, this.offset, this.length, other, otherOffset, otherLength);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.value, this.offset, this.length);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.write(this.value, this.offset, this.length);
        }
    }
}

