/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.schema;

import net.snowflake.ingest.internal.apache.parquet.schema.GroupType;
import net.snowflake.ingest.internal.apache.parquet.schema.InvalidSchemaException;
import net.snowflake.ingest.internal.apache.parquet.schema.MessageType;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveType;
import net.snowflake.ingest.internal.apache.parquet.schema.Type;
import net.snowflake.ingest.internal.apache.parquet.schema.TypeVisitor;

public class TypeUtil {
    public static void checkValidWriteSchema(GroupType schema) {
        schema.accept(new TypeVisitor(){

            @Override
            public void visit(GroupType groupType) {
                if (groupType.getFieldCount() <= 0) {
                    throw new InvalidSchemaException("Cannot write a schema with an empty group: " + groupType);
                }
                for (Type type : groupType.getFields()) {
                    type.accept(this);
                }
            }

            @Override
            public void visit(MessageType messageType) {
                this.visit((GroupType)messageType);
            }

            @Override
            public void visit(PrimitiveType primitiveType) {
            }
        });
    }
}

