/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose;

import net.snowflake.ingest.internal.com.nimbusds.jose.IllegalHeaderException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.UnprotectedHeader;

class HeaderValidation {
    static void ensureDisjoint(JWSHeader jwsHeader, UnprotectedHeader unprotectedHeader) throws IllegalHeaderException {
        if (jwsHeader == null || unprotectedHeader == null) {
            return;
        }
        for (String unprotectedParamName : unprotectedHeader.getIncludedParams()) {
            if (!jwsHeader.getIncludedParams().contains(unprotectedParamName)) continue;
            throw new IllegalHeaderException("The parameters in the JWS protected header and the unprotected header must be disjoint");
        }
    }

    private HeaderValidation() {
    }
}

