/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;

class HadoopJdkGzipInputStream
extends CompressionInputStream {
    private final byte[] oneByte = new byte[1];
    private final GZIPInputStream input;

    public HadoopJdkGzipInputStream(InputStream input, int bufferSize) throws IOException {
        super(input);
        this.input = new GZIPInputStream(input, bufferSize);
    }

    @Override
    public int read() throws IOException {
        int length = this.input.read(this.oneByte, 0, 1);
        if (length < 0) {
            return length;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        return this.input.read(output, offset, length);
    }

    @Override
    public void resetState() throws IOException {
        throw new UnsupportedOperationException("resetState not supported for gzip");
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.input.close();
        }
    }
}

