/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.lzo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.io.airlift.compress.lzo.HadoopLzopInputStream;
import net.snowflake.ingest.internal.io.airlift.compress.lzo.HadoopLzopOutputStream;
import net.snowflake.ingest.internal.io.airlift.compress.lzo.LzoCodec;

public class LzopCodec
implements Configurable,
CompressionCodec {
    static final byte[] LZOP_MAGIC = new byte[]{-119, 76, 90, 79, 0, 13, 10, 26, 10};
    static final byte LZO_1X_VARIANT = 1;
    private Configuration conf;

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new HadoopLzopOutputStream(out, this.getBufferSize());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new HadoopLzopOutputStream(out, this.getBufferSize());
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Compressor createCompressor() {
        return new LzoCodec.HadoopLzoCompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new HadoopLzopInputStream(in, this.getBufferSize());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new HadoopLzopInputStream(in, this.getBufferSize());
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return LzoCodec.HadoopLzoDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        return new LzoCodec.HadoopLzoDecompressor();
    }

    @Override
    public String getDefaultExtension() {
        return ".lzo";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.lzo.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }
}

