/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.zstd;

import net.snowflake.ingest.internal.io.airlift.compress.zstd.FiniteStateEntropy;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.FseCompressionTable;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.UnsafeUtil;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.Util;

class FseTableReader {
    private final short[] nextSymbol = new short[256];
    private final short[] normalizedCounters = new short[256];

    FseTableReader() {
    }

    public int readFseTable(FiniteStateEntropy.Table table, Object inputBase, long inputAddress, long inputLimit, int maxSymbol, int maxTableLog) {
        long input = inputAddress;
        Util.verify(inputLimit - inputAddress >= 4L, input, "Not enough input bytes");
        int symbolNumber = 0;
        boolean previousIsZero = false;
        int bitStream = UnsafeUtil.UNSAFE.getInt(inputBase, input);
        int tableLog = (bitStream & 0xF) + 5;
        int numberOfBits = tableLog + 1;
        bitStream >>>= 4;
        int bitCount = 4;
        Util.verify(tableLog <= maxTableLog, input, "FSE table size exceeds maximum allowed size");
        int remaining = (1 << tableLog) + 1;
        int threshold = 1 << tableLog;
        while (remaining > 1 && symbolNumber <= maxSymbol) {
            short count;
            short max;
            if (previousIsZero) {
                int n0 = symbolNumber;
                while ((bitStream & 0xFFFF) == 65535) {
                    n0 += 24;
                    if (input < inputLimit - 5L) {
                        bitStream = UnsafeUtil.UNSAFE.getInt(inputBase, input += 2L) >>> bitCount;
                        continue;
                    }
                    bitStream >>>= 16;
                    bitCount += 16;
                }
                while ((bitStream & 3) == 3) {
                    n0 += 3;
                    bitStream >>>= 2;
                    bitCount += 2;
                }
                bitCount += 2;
                Util.verify((n0 += bitStream & 3) <= maxSymbol, input, "Symbol larger than max value");
                while (symbolNumber < n0) {
                    this.normalizedCounters[symbolNumber++] = 0;
                }
                if (input <= inputLimit - 7L || input + (long)(bitCount >>> 3) <= inputLimit - 4L) {
                    input += (long)(bitCount >>> 3);
                    bitStream = UnsafeUtil.UNSAFE.getInt(inputBase, input) >>> (bitCount &= 7);
                } else {
                    bitStream >>>= 2;
                }
            }
            if ((bitStream & threshold - 1) < (max = (short)(2 * threshold - 1 - remaining))) {
                count = (short)(bitStream & threshold - 1);
                bitCount += numberOfBits - 1;
            } else {
                count = (short)(bitStream & 2 * threshold - 1);
                if (count >= threshold) {
                    count = (short)(count - max);
                }
                bitCount += numberOfBits;
            }
            count = (short)(count - 1);
            remaining -= Math.abs(count);
            this.normalizedCounters[symbolNumber++] = count;
            boolean bl = previousIsZero = count == 0;
            while (remaining < threshold) {
                --numberOfBits;
                threshold >>>= 1;
            }
            if (input <= inputLimit - 7L || input + (long)(bitCount >> 3) <= inputLimit - 4L) {
                input += (long)(bitCount >>> 3);
                bitCount &= 7;
            } else {
                bitCount -= (int)(8L * (inputLimit - 4L - input));
                input = inputLimit - 4L;
            }
            bitStream = UnsafeUtil.UNSAFE.getInt(inputBase, input) >>> (bitCount & 0x1F);
        }
        Util.verify(remaining == 1 && bitCount <= 32, input, "Input is corrupted");
        maxSymbol = symbolNumber - 1;
        Util.verify(maxSymbol <= 255, input, "Max symbol value too large (too many symbols for FSE)");
        input += (long)(bitCount + 7 >> 3);
        int symbolCount = maxSymbol + 1;
        int tableSize = 1 << tableLog;
        int highThreshold = tableSize - 1;
        table.log2Size = tableLog;
        for (int symbol = 0; symbol < symbolCount; symbol = (int)((byte)(symbol + 1))) {
            if (this.normalizedCounters[symbol] == -1) {
                table.symbol[highThreshold--] = symbol;
                this.nextSymbol[symbol] = 1;
                continue;
            }
            this.nextSymbol[symbol] = this.normalizedCounters[symbol];
        }
        int position = FseCompressionTable.spreadSymbols(this.normalizedCounters, maxSymbol, tableSize, highThreshold, table.symbol);
        Util.verify(position == 0, input, "Input is corrupted");
        for (int i = 0; i < tableSize; ++i) {
            short nextState;
            byte symbol;
            byte by = symbol = table.symbol[i];
            this.nextSymbol[by] = (short)(this.nextSymbol[by] + 1);
            table.numberOfBits[i] = (byte)(tableLog - Util.highestBit(nextState));
            table.newState[i] = (short)((nextState << table.numberOfBits[i]) - tableSize);
        }
        return (int)(input - inputAddress);
    }

    public static void initializeRleTable(FiniteStateEntropy.Table table, byte value) {
        table.log2Size = 0;
        table.symbol[0] = value;
        table.newState[0] = 0;
        table.numberOfBits[0] = 0;
    }
}

