/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.cert.cmp;

import java.math.BigInteger;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cmp.CMPCertificate;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cmp.CertStatus;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.ingest.internal.org.bouncycastle.cert.cmp.CMPException;
import net.snowflake.ingest.internal.org.bouncycastle.cert.cmp.CMPUtil;
import net.snowflake.ingest.internal.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import net.snowflake.ingest.internal.org.bouncycastle.operator.DigestCalculator;
import net.snowflake.ingest.internal.org.bouncycastle.operator.DigestCalculatorProvider;
import net.snowflake.ingest.internal.org.bouncycastle.operator.OperatorCreationException;
import net.snowflake.ingest.internal.org.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), digestCalculatorProvider);
    }

    public boolean isVerified(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        DigestCalculator digestCalculator;
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgFinder.find(algorithmIdentifier);
        if (algorithmIdentifier2 == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digestCalculator = digestCalculatorProvider.get(algorithmIdentifier2);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMPException("unable to create digester: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        CMPUtil.derEncodeToStream(cMPCertificate, digestCalculator.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digestCalculator.getDigest());
    }
}

