/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.cms;

import java.io.IOException;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.KEKIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.cms.AuthAttributesProvider;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSSecureReadable;
import net.snowflake.ingest.internal.org.bouncycastle.cms.KEKRecipient;
import net.snowflake.ingest.internal.org.bouncycastle.cms.KEKRecipientId;
import net.snowflake.ingest.internal.org.bouncycastle.cms.Recipient;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientInformation;
import net.snowflake.ingest.internal.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

