/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.dvcs;

import java.io.IOException;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSProcessableByteArray;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSSignedData;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSSignedDataGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.dvcs.DVCSException;
import net.snowflake.ingest.internal.org.bouncycastle.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

