/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.pkcs;

import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.pkcs.Attribute;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x500.X500Name;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.Extensions;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class DeltaCertificateRequestAttribute {
    private final X500Name subject;
    private final SubjectPublicKeyInfo subjectPKInfo;
    private final Extensions extensions;
    private final AlgorithmIdentifier signatureAlgorithm;

    public DeltaCertificateRequestAttribute(Attribute attribute) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(attribute.getAttrValues().getObjectAt(0));
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.subject = X500Name.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(0)), true);
            ++n;
        } else {
            this.subject = null;
        }
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(n));
        Extensions extensions = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        if (++n != aSN1Sequence.size()) {
            while (n < aSN1Sequence.size()) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(n));
                if (aSN1TaggedObject.getTagNo() == 1) {
                    extensions = Extensions.getInstance(aSN1TaggedObject, false);
                } else if (aSN1TaggedObject.getTagNo() == 2) {
                    algorithmIdentifier = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                } else {
                    throw new IllegalArgumentException("unknown tag");
                }
                ++n;
            }
        }
        this.extensions = extensions;
        this.signatureAlgorithm = algorithmIdentifier;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPKInfo() {
        return this.subjectPKInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }
}

