/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.dilithium;

import java.security.SecureRandom;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.KeyGenerationParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyGenerationParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;

public class DilithiumKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DilithiumParameters dilithiumParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.dilithiumParams = ((DilithiumKeyGenerationParameters)keyGenerationParameters).getParameters();
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        DilithiumEngine dilithiumEngine = this.dilithiumParams.getEngine(this.random);
        byte[][] byArray = dilithiumEngine.generateKeyPair();
        DilithiumPublicKeyParameters dilithiumPublicKeyParameters = new DilithiumPublicKeyParameters(this.dilithiumParams, byArray[0], byArray[6]);
        DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters = new DilithiumPrivateKeyParameters(this.dilithiumParams, byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6]);
        return new AsymmetricCipherKeyPair(dilithiumPublicKeyParameters, dilithiumPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

