/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs;

import java.util.Comparator;
import java.util.List;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs.LongArrays;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs.LongCollection;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs.LongComparator;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs.LongComparators;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs.LongListIterator;

public interface LongList
extends List<Long>,
Comparable<List<? extends Long>>,
LongCollection {
    @Override
    public LongListIterator iterator();

    public LongListIterator listIterator();

    public LongListIterator listIterator(int var1);

    public LongList subList(int var1, int var2);

    public void size(int var1);

    public void getElements(int var1, long[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    public void addElements(int var1, long[] var2);

    public void addElements(int var1, long[] var2, int var3, int var4);

    default public void setElements(long[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index, long[] a) {
        this.setElements(index, a, 0, a.length);
    }

    default public void setElements(int index, long[] a, int offset, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        LongArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        LongListIterator iter = this.listIterator(index);
        int i = 0;
        while (i < length) {
            iter.nextLong();
            iter.set(a[offset + i++]);
        }
    }

    @Override
    public boolean add(long var1);

    @Override
    public void add(int var1, long var2);

    @Override
    @Deprecated
    default public void add(int index, Long key) {
        this.add(index, (long)key);
    }

    public boolean addAll(int var1, LongCollection var2);

    public boolean addAll(int var1, LongList var2);

    public boolean addAll(LongList var1);

    @Override
    public long set(int var1, long var2);

    public long getLong(int var1);

    public int indexOf(long var1);

    public int lastIndexOf(long var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return LongCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Long)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Long)o);
    }

    @Override
    @Deprecated
    default public boolean add(Long k) {
        return this.add((long)k);
    }

    public long removeLong(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return LongCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Long remove(int index) {
        return this.removeLong(index);
    }

    @Override
    @Deprecated
    default public Long set(int index, Long k) {
        return this.set(index, (long)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Long> comparator) {
        this.sort(LongComparators.asLongComparator(comparator));
    }

    default public void sort(LongComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            long[] elements = this.toLongArray();
            LongArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    @Deprecated
    default public void unstableSort(Comparator<? super Long> comparator) {
        this.unstableSort(LongComparators.asLongComparator(comparator));
    }

    default public void unstableSort(LongComparator comparator) {
        long[] elements = this.toLongArray();
        if (comparator == null) {
            LongArrays.unstableSort(elements);
        } else {
            LongArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

