/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.Access;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.ByteBufferAccess;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.CharSequenceAccess;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.CityAndFarmHash_1_1;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.HotSpotPrior7u6StringHash;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.MetroHash;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.ModernHotSpotStringHash;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.MurmurHash_3;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.StringHash;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.UnknownJvmStringHash;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.UnsafeAccess;
import net.snowflake.ingest.internal.shaded.parquet.net.openhft.hashing.XxHash;
import org.jetbrains.annotations.NotNull;
import sun.nio.ch.DirectBuffer;

public abstract class LongHashFunction
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final boolean NATIVE_LITTLE_ENDIAN;
    private static final byte TRUE_BYTE_VALUE;
    private static final byte FALSE_BYTE_VALUE;
    private static StringHash stringHash;

    private static byte trueByteValue() {
        return UnsafeAccess.UNSAFE.getByte(new boolean[]{true}, UnsafeAccess.BOOLEAN_BASE);
    }

    private static byte falseByteValue() {
        return UnsafeAccess.UNSAFE.getByte(new boolean[]{false}, UnsafeAccess.BOOLEAN_BASE);
    }

    public static LongHashFunction city_1_1() {
        return CityAndFarmHash_1_1.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction city_1_1(long seed) {
        return CityAndFarmHash_1_1.asLongHashFunctionWithSeed(seed);
    }

    public static LongHashFunction city_1_1(long seed0, long seed1) {
        return CityAndFarmHash_1_1.asLongHashFunctionWithTwoSeeds(seed0, seed1);
    }

    public static LongHashFunction farmNa() {
        return CityAndFarmHash_1_1.naWithoutSeeds();
    }

    public static LongHashFunction farmNa(long seed) {
        return CityAndFarmHash_1_1.naWithSeed(seed);
    }

    public static LongHashFunction farmNa(long seed0, long seed1) {
        return CityAndFarmHash_1_1.naWithSeeds(seed0, seed1);
    }

    public static LongHashFunction farmUo() {
        return CityAndFarmHash_1_1.uoWithoutSeeds();
    }

    public static LongHashFunction farmUo(long seed) {
        return CityAndFarmHash_1_1.uoWithSeed(seed);
    }

    public static LongHashFunction farmUo(long seed0, long seed1) {
        return CityAndFarmHash_1_1.uoWithSeeds(seed0, seed1);
    }

    public static LongHashFunction murmur_3() {
        return MurmurHash_3.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction murmur_3(long seed) {
        return MurmurHash_3.asLongHashFunctionWithSeed(seed);
    }

    public static LongHashFunction xx() {
        return XxHash.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction xx(long seed) {
        return XxHash.asLongHashFunctionWithSeed(seed);
    }

    public static LongHashFunction metro() {
        return MetroHash.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction metro(long seed) {
        return MetroHash.asLongHashFunctionWithSeed(seed);
    }

    private static void checkArrayOffs(int arrayLength, int off, int len) {
        if (len < 0 || off < 0 || off + len > arrayLength || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected LongHashFunction() {
    }

    public abstract long hashLong(long var1);

    public abstract long hashInt(int var1);

    public abstract long hashShort(short var1);

    public abstract long hashChar(char var1);

    public abstract long hashByte(byte var1);

    public abstract long hashVoid();

    public abstract <T> long hash(T var1, Access<T> var2, long var3, long var5);

    private long unsafeHash(Object input, long off, long len) {
        return this.hash(input, UnsafeAccess.INSTANCE, off, len);
    }

    public long hashBoolean(boolean input) {
        return this.hashByte(input ? TRUE_BYTE_VALUE : FALSE_BYTE_VALUE);
    }

    public long hashBooleans(@NotNull boolean[] input) {
        return this.unsafeHash(input, UnsafeAccess.BOOLEAN_BASE, input.length);
    }

    public long hashBooleans(@NotNull boolean[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.BOOLEAN_BASE + (long)off, len);
    }

    public long hashBytes(@NotNull byte[] input) {
        return this.unsafeHash(input, UnsafeAccess.BYTE_BASE, input.length);
    }

    public long hashBytes(@NotNull byte[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.BYTE_BASE + (long)off, len);
    }

    public long hashBytes(ByteBuffer input) {
        return this.hashByteBuffer(input, input.position(), input.remaining());
    }

    public long hashBytes(@NotNull ByteBuffer input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.capacity(), off, len);
        return this.hashByteBuffer(input, off, len);
    }

    private long hashByteBuffer(@NotNull ByteBuffer input, int off, int len) {
        if (input.hasArray()) {
            return this.unsafeHash(input.array(), UnsafeAccess.BYTE_BASE + (long)input.arrayOffset() + (long)off, len);
        }
        if (input instanceof DirectBuffer) {
            return this.unsafeHash(null, ((DirectBuffer)((Object)input)).address() + (long)off, len);
        }
        return this.hash(input, ByteBufferAccess.INSTANCE, off, len);
    }

    public long hashMemory(long address, long len) {
        return this.unsafeHash(null, address, len);
    }

    public long hashChars(@NotNull char[] input) {
        return this.unsafeHash(input, UnsafeAccess.CHAR_BASE, (long)input.length * 2L);
    }

    public long hashChars(@NotNull char[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.CHAR_BASE + (long)off * 2L, (long)len * 2L);
    }

    public long hashChars(@NotNull String input) {
        return stringHash.longHash(input, this, 0, input.length());
    }

    public long hashChars(@NotNull String input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length(), off, len);
        return stringHash.longHash(input, this, off, len);
    }

    public long hashChars(@NotNull StringBuilder input) {
        return this.hashNativeChars(input);
    }

    public long hashChars(@NotNull StringBuilder input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length(), off, len);
        return this.hashNativeChars(input, off, len);
    }

    long hashNativeChars(CharSequence input) {
        return this.hashNativeChars(input, 0, input.length());
    }

    long hashNativeChars(CharSequence input, int off, int len) {
        return this.hash(input, CharSequenceAccess.nativeCharSequenceAccess(), (long)off * 2L, (long)len * 2L);
    }

    public long hashShorts(@NotNull short[] input) {
        return this.unsafeHash(input, UnsafeAccess.SHORT_BASE, (long)input.length * 2L);
    }

    public long hashShorts(@NotNull short[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.SHORT_BASE + (long)off * 2L, (long)len * 2L);
    }

    public long hashInts(@NotNull int[] input) {
        return this.unsafeHash(input, UnsafeAccess.INT_BASE, (long)input.length * 4L);
    }

    public long hashInts(@NotNull int[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.INT_BASE + (long)off * 4L, (long)len * 4L);
    }

    public long hashLongs(@NotNull long[] input) {
        return this.unsafeHash(input, UnsafeAccess.LONG_BASE, (long)input.length * 8L);
    }

    public long hashLongs(@NotNull long[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.LONG_BASE + (long)off * 8L, (long)len * 8L);
    }

    static {
        byte falseByteValue;
        byte trueByteValue;
        NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        try {
            trueByteValue = LongHashFunction.trueByteValue();
            falseByteValue = LongHashFunction.falseByteValue();
        }
        catch (Throwable t2) {
            trueByteValue = 1;
            falseByteValue = 0;
        }
        TRUE_BYTE_VALUE = trueByteValue;
        FALSE_BYTE_VALUE = falseByteValue;
        try {
            String javaVersion;
            stringHash = System.getProperty("java.vm.name").contains("HotSpot") ? ((javaVersion = System.getProperty("java.version")).compareTo("1.7.0_06") >= 0 ? (javaVersion.compareTo("1.9") >= 0 ? UnknownJvmStringHash.INSTANCE : ModernHotSpotStringHash.INSTANCE) : HotSpotPrior7u6StringHash.INSTANCE) : HotSpotPrior7u6StringHash.INSTANCE;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (stringHash == null) {
                stringHash = UnknownJvmStringHash.INSTANCE;
            }
        }
    }
}

