/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.example;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.ingest.streaming.InsertValidationResponse;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClient;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClientFactory;

public class SnowflakeStreamingIngestExample {
    private static String PROFILE_PATH = "profile.json";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        Iterator<Map.Entry<String, JsonNode>> propIt = mapper.readTree(new String(Files.readAllBytes(Paths.get(PROFILE_PATH, new String[0])))).fields();
        while (propIt.hasNext()) {
            Map.Entry<String, JsonNode> prop = propIt.next();
            props.put(prop.getKey(), prop.getValue().asText());
        }
        try (SnowflakeStreamingIngestClient client = SnowflakeStreamingIngestClientFactory.builder("MY_CLIENT").setProperties(props).build();){
            OpenChannelRequest request1 = OpenChannelRequest.builder("MY_CHANNEL").setDBName("MY_DATABASE").setSchemaName("MY_SCHEMA").setTableName("MY_TABLE").setOnErrorOption(OpenChannelRequest.OnErrorOption.CONTINUE).build();
            SnowflakeStreamingIngestChannel channel1 = client.openChannel(request1);
            int totalRowsInTable = 1000;
            for (int val = 0; val < 1000; ++val) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("c1", val);
                InsertValidationResponse response = channel1.insertRow(row, String.valueOf(val));
                if (!response.hasErrors()) continue;
                throw response.getInsertErrors().get(0).getException();
            }
            int expectedOffsetTokenInSnowflake = 999;
            int maxRetries = 10;
            int retryCount = 0;
            do {
                String offsetTokenFromSnowflake;
                if ((offsetTokenFromSnowflake = channel1.getLatestCommittedOffsetToken()) == null || !offsetTokenFromSnowflake.equals(String.valueOf(999))) continue;
                System.out.println("SUCCESSFULLY inserted 1000 rows");
                break;
            } while (++retryCount < 10);
            channel1.close().get();
        }
    }
}

