/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.snowflake.ingest.streaming.internal.ChannelFlushContext;
import net.snowflake.ingest.streaming.internal.Flusher;
import net.snowflake.ingest.streaming.internal.RowBufferStats;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Pair;
import net.snowflake.ingest.utils.SFException;

class ChannelData<T> {
    private Long rowSequencer;
    private String offsetToken;
    private T vectors;
    private float bufferSize;
    private int rowCount;
    private Map<String, RowBufferStats> columnEps;
    private Pair<Long, Long> minMaxInsertTimeInMs;
    private ChannelFlushContext channelFlushContext;
    private Supplier<Flusher<T>> flusherFactory;

    ChannelData() {
    }

    public static Map<String, RowBufferStats> getCombinedColumnStatsMap(Map<String, RowBufferStats> left, Map<String, RowBufferStats> right) {
        if (left == null || right == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "null column stats");
        }
        if (left.size() != right.size()) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, String.format("Column stats map key size mismatch, left=%d, right=%d, leftKeySet=%s, rightKeySet=%s", left.size(), right.size(), left.keySet(), right.keySet()));
        }
        HashMap<String, RowBufferStats> result = new HashMap<String, RowBufferStats>();
        try {
            for (String key : left.keySet()) {
                RowBufferStats leftStats = left.get(key);
                RowBufferStats rightStats = right.get(key);
                result.put(key, RowBufferStats.getCombinedStats(leftStats, rightStats));
            }
        }
        catch (NullPointerException npe) {
            throw new SFException(npe, ErrorCode.INTERNAL_ERROR, "Column stats map key mismatch");
        }
        return result;
    }

    public static Pair<Long, Long> getCombinedMinMaxInsertTimeInMs(Pair<Long, Long> left, Pair<Long, Long> right) {
        return new Pair<Long, Long>(Math.min(left.getFirst(), right.getFirst()), Math.max(left.getSecond(), right.getSecond()));
    }

    public Map<String, RowBufferStats> getColumnEps() {
        return this.columnEps;
    }

    public void setColumnEps(Map<String, RowBufferStats> columnEps) {
        this.columnEps = columnEps;
    }

    Long getRowSequencer() {
        return this.rowSequencer;
    }

    void setRowSequencer(Long rowSequencer) {
        this.rowSequencer = rowSequencer;
    }

    String getOffsetToken() {
        return this.offsetToken;
    }

    void setOffsetToken(String offsetToken) {
        this.offsetToken = offsetToken;
    }

    T getVectors() {
        return this.vectors;
    }

    void setVectors(T vectors) {
        this.vectors = vectors;
    }

    int getRowCount() {
        return this.rowCount;
    }

    void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    float getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(float bufferSize) {
        this.bufferSize = bufferSize;
    }

    public ChannelFlushContext getChannelContext() {
        return this.channelFlushContext;
    }

    public void setChannelContext(ChannelFlushContext channelFlushContext) {
        this.channelFlushContext = channelFlushContext;
    }

    public Flusher<T> createFlusher() {
        return this.flusherFactory.get();
    }

    public void setFlusherFactory(Supplier<Flusher<T>> flusherFactory) {
        this.flusherFactory = flusherFactory;
    }

    Pair<Long, Long> getMinMaxInsertTimeInMs() {
        return this.minMaxInsertTimeInMs;
    }

    void setMinMaxInsertTimeInMs(Pair<Long, Long> minMaxInsertTimeInMs) {
        this.minMaxInsertTimeInMs = minMaxInsertTimeInMs;
    }

    public String toString() {
        return "ChannelData{rowSequencer=" + this.rowSequencer + ", offsetToken='" + this.offsetToken + '\'' + ", bufferSize=" + this.bufferSize + ", rowCount=" + this.rowCount + ", channelContext=" + this.channelFlushContext + '}';
    }
}

