/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.internal.javax.annotation.Nullable;
import net.snowflake.ingest.streaming.internal.ChannelFlushContext;
import net.snowflake.ingest.utils.Utils;

class ChannelMetadata {
    private final String channelName;
    private final Long clientSequencer;
    private final Long rowSequencer;
    @Nullable
    private final String offsetToken;

    static Builder builder() {
        return new Builder();
    }

    private ChannelMetadata(Builder builder) {
        Utils.assertStringNotNullOrEmpty("channel name", builder.channelName);
        Utils.assertNotNull("channel client sequencer", builder.clientSequencer);
        Utils.assertNotNull("channel row sequencer", builder.rowSequencer);
        this.channelName = builder.channelName;
        this.clientSequencer = builder.clientSequencer;
        this.rowSequencer = builder.rowSequencer;
        this.offsetToken = builder.offsetToken;
    }

    @JsonProperty(value="channel_name")
    String getChannelName() {
        return this.channelName;
    }

    @JsonProperty(value="client_sequencer")
    Long getClientSequencer() {
        return this.clientSequencer;
    }

    @JsonProperty(value="row_sequencer")
    Long getRowSequencer() {
        return this.rowSequencer;
    }

    @Nullable
    @JsonProperty(value="offset_token")
    String getOffsetToken() {
        return this.offsetToken;
    }

    static class Builder {
        private String channelName;
        private Long clientSequencer;
        private Long rowSequencer;
        @Nullable
        private String offsetToken;

        Builder() {
        }

        Builder setOwningChannelFromContext(ChannelFlushContext channelFlushContext) {
            this.channelName = channelFlushContext.getName();
            this.clientSequencer = channelFlushContext.getChannelSequencer();
            return this;
        }

        Builder setRowSequencer(Long rowSequencer) {
            this.rowSequencer = rowSequencer;
            return this;
        }

        Builder setOffsetToken(String offsetToken) {
            this.offsetToken = offsetToken;
            return this;
        }

        ChannelMetadata build() {
            return new ChannelMetadata(this);
        }
    }
}

