/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.HashMap;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.LiteralQuoteUtils;

class ColumnMetadata {
    private String name;
    private String internalName;
    private String type;
    private String logicalType;
    private String physicalType;
    private Integer precision;
    private Integer scale;
    private Integer byteLength;
    private Integer length;
    private boolean nullable;
    private String collation;
    private Integer ordinal;

    ColumnMetadata() {
    }

    @JsonProperty(value="name")
    void setName(String name) {
        this.name = name;
        this.internalName = LiteralQuoteUtils.unquoteColumnName(name);
    }

    String getName() {
        return this.name;
    }

    @JsonProperty(value="collation")
    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    @JsonProperty(value="type")
    void setType(String type) {
        this.type = type;
    }

    String getType() {
        return this.type;
    }

    @JsonProperty(value="logical_type")
    void setLogicalType(String logicalType) {
        this.logicalType = logicalType.toUpperCase();
    }

    String getLogicalType() {
        return this.logicalType;
    }

    @JsonProperty(value="physical_type")
    void setPhysicalType(String physicalType) {
        this.physicalType = physicalType;
    }

    String getPhysicalType() {
        return this.physicalType;
    }

    @JsonProperty(value="precision")
    void setPrecision(Integer precision) {
        this.precision = precision;
    }

    Integer getPrecision() {
        return this.precision;
    }

    @JsonProperty(value="scale")
    void setScale(Integer scale) {
        this.scale = scale;
    }

    Integer getScale() {
        return this.scale;
    }

    @JsonProperty(value="byte_length")
    void setByteLength(Integer byteLength) {
        this.byteLength = byteLength;
    }

    Integer getByteLength() {
        return this.byteLength;
    }

    @JsonProperty(value="length")
    void setLength(Integer length) {
        this.length = length;
    }

    Integer getLength() {
        return this.length;
    }

    @JsonProperty(value="nullable")
    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    boolean getNullable() {
        return this.nullable;
    }

    @JsonProperty(value="ordinal")
    void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public Integer getOrdinal() {
        return this.ordinal;
    }

    String getInternalName() {
        return this.internalName;
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("type", this.type);
        map.put("logical_type", this.logicalType);
        map.put("physical_type", this.physicalType);
        map.put("precision", this.precision);
        map.put("scale", this.scale);
        map.put("byte_length", this.byteLength);
        map.put("length", this.length);
        map.put("nullable", this.nullable);
        return ((Object)map).toString();
    }
}

