/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.math.BigInteger;
import java.util.Objects;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.BinaryStringUtils;
import net.snowflake.ingest.streaming.internal.RowBufferStats;

class FileColumnProperties {
    private String minStrValue;
    private String maxStrValue;
    private String collation;
    private String minStrNonCollated;
    private String maxStrNonCollated;
    private BigInteger minIntValue;
    private BigInteger maxIntValue;
    private Double minRealValue;
    private Double maxRealValue;
    private long distinctValues;
    private long nullCount;
    private long maxLength;
    public static final BigInteger DEFAULT_MIN_MAX_INT_VAL_FOR_EP = BigInteger.valueOf(0L);
    public static final Double DEFAULT_MIN_MAX_REAL_VAL_FOR_EP = 0.0;

    FileColumnProperties(RowBufferStats stats) {
        String truncatedAsHex;
        this.setCollation(stats.getCollationDefinitionString());
        this.setMaxIntValue(stats.getCurrentMaxIntValue() == null ? DEFAULT_MIN_MAX_INT_VAL_FOR_EP : stats.getCurrentMaxIntValue());
        this.setMinIntValue(stats.getCurrentMinIntValue() == null ? DEFAULT_MIN_MAX_INT_VAL_FOR_EP : stats.getCurrentMinIntValue());
        this.setMinRealValue(stats.getCurrentMinRealValue() == null ? DEFAULT_MIN_MAX_REAL_VAL_FOR_EP : stats.getCurrentMinRealValue());
        this.setMaxRealValue(stats.getCurrentMaxRealValue() == null ? DEFAULT_MIN_MAX_REAL_VAL_FOR_EP : stats.getCurrentMaxRealValue());
        this.setMaxLength(stats.getCurrentMaxLength());
        this.setMaxStrNonCollated(null);
        this.setMinStrNonCollated(null);
        if (stats.getCurrentMinStrValue() != null) {
            truncatedAsHex = BinaryStringUtils.truncateBytesAsHex(stats.getCurrentMinStrValue(), false);
            this.setMinStrValue(truncatedAsHex);
        }
        if (stats.getCurrentMaxStrValue() != null) {
            truncatedAsHex = BinaryStringUtils.truncateBytesAsHex(stats.getCurrentMaxStrValue(), true);
            this.setMaxStrValue(truncatedAsHex);
        }
        this.setNullCount(stats.getCurrentNullCount());
        this.setDistinctValues(stats.getDistinctValues());
    }

    @JsonProperty(value="minStrValue")
    String getMinStrValue() {
        return this.minStrValue;
    }

    void setMinStrValue(String minStrValue) {
        this.minStrValue = minStrValue;
    }

    @JsonProperty(value="maxStrValue")
    String getMaxStrValue() {
        return this.maxStrValue;
    }

    void setMaxStrValue(String maxStrValue) {
        this.maxStrValue = maxStrValue;
    }

    @JsonProperty(value="minIntValue")
    BigInteger getMinIntValue() {
        return this.minIntValue;
    }

    void setMinIntValue(BigInteger minIntValue) {
        this.minIntValue = minIntValue;
    }

    @JsonProperty(value="maxIntValue")
    BigInteger getMaxIntValue() {
        return this.maxIntValue;
    }

    void setMaxIntValue(BigInteger maxIntValue) {
        this.maxIntValue = maxIntValue;
    }

    @JsonProperty(value="nullCount")
    long getNullCount() {
        return this.nullCount;
    }

    void setNullCount(long nullCount) {
        this.nullCount = nullCount;
    }

    @JsonProperty(value="minRealValue")
    Double getMinRealValue() {
        return this.minRealValue;
    }

    void setMinRealValue(Double minRealValue) {
        this.minRealValue = minRealValue;
    }

    @JsonProperty(value="maxRealValue")
    Double getMaxRealValue() {
        return this.maxRealValue;
    }

    void setMaxRealValue(Double maxRealValue) {
        this.maxRealValue = maxRealValue;
    }

    @JsonProperty(value="distinctValues")
    long getDistinctValues() {
        return this.distinctValues;
    }

    void setDistinctValues(long distinctValues) {
        this.distinctValues = distinctValues;
    }

    @JsonProperty(value="maxLength")
    long getMaxLength() {
        return this.maxLength;
    }

    void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    @JsonProperty(value="collation")
    String getCollation() {
        return this.collation;
    }

    void setCollation(String collation) {
        this.collation = collation;
    }

    @JsonProperty(value="minStrNonCollated")
    String getMinStrNonCollated() {
        return this.minStrNonCollated;
    }

    void setMinStrNonCollated(String minStrNonCollated) {
        this.minStrNonCollated = minStrNonCollated;
    }

    @JsonProperty(value="maxStrNonCollated")
    String getMaxStrNonCollated() {
        return this.maxStrNonCollated;
    }

    void setMaxStrNonCollated(String maxStrNonCollated) {
        this.maxStrNonCollated = maxStrNonCollated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.minIntValue != null) {
            sb.append(", \"minIntValue\": ").append(this.minIntValue);
            sb.append(", \"maxIntValue\": ").append(this.maxIntValue);
        } else if (this.minRealValue != null) {
            sb.append(", \"minRealValue\": ").append(this.minRealValue);
            sb.append(", \"maxRealValue\": ").append(this.maxRealValue);
        } else {
            sb.append(", \"minStrValue\": \"").append(this.minStrValue).append('\"');
            sb.append(", \"maxStrValue\": \"").append(this.maxStrValue).append('\"');
            sb.append(", \"minStrNonCollatedValue\": \"").append(this.minStrNonCollated).append('\"');
            sb.append(", \"maxStrNonCollatedValue\": \"").append(this.maxStrNonCollated).append('\"');
            sb.append(", \"collation\": \"").append(this.collation).append('\"');
            sb.append(", \"maxLength\": ").append(this.maxLength);
        }
        sb.append(", \"distinctValues\": ").append(this.distinctValues);
        sb.append(", \"nullCount\": ").append(this.nullCount);
        return sb.append('}').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileColumnProperties that = (FileColumnProperties)o;
        return this.distinctValues == that.distinctValues && this.nullCount == that.nullCount && this.maxLength == that.maxLength && Objects.equals(this.minStrValue, that.minStrValue) && Objects.equals(this.maxStrValue, that.maxStrValue) && Objects.equals(this.collation, that.collation) && Objects.equals(this.minStrNonCollated, that.minStrNonCollated) && Objects.equals(this.maxStrNonCollated, that.maxStrNonCollated) && Objects.equals(this.minIntValue, that.minIntValue) && Objects.equals(this.maxIntValue, that.maxIntValue) && Objects.equals(this.minRealValue, that.minRealValue) && Objects.equals(this.maxRealValue, that.maxRealValue);
    }

    public int hashCode() {
        return Objects.hash(this.minStrValue, this.maxStrValue, this.collation, this.minStrNonCollated, this.maxStrNonCollated, this.minIntValue, this.maxIntValue, this.minRealValue, this.maxRealValue, this.distinctValues, this.nullCount, this.maxLength);
    }
}

