/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.util.Map;
import java.util.Objects;

public class Pair<F, S> {
    private final F first;
    private final S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public Pair(Map.Entry<F, S> entry) {
        this.first = entry.getKey();
        this.second = entry.getValue();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!Pair.class.isInstance(other)) {
            return false;
        }
        Pair pair2 = (Pair)other;
        return Objects.equals(this.first, pair2.getFirst()) && Objects.equals(this.second, pair2.getSecond());
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public F getKey() {
        return this.getFirst();
    }

    public S getValue() {
        return this.getSecond();
    }

    public int hashCode() {
        return 37 * Objects.hashCode(this.first) + Objects.hashCode(this.second);
    }

    public String toString() {
        return "[ " + this.first + ", " + this.second + " ]";
    }
}

