/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;

public class SnowflakeURL {
    private static final Logging logger = new Logging(SnowflakeURL.class);
    private String jdbcUrl;
    private String url;
    private boolean ssl;
    private String account;
    private int port;

    private SnowflakeURL(SnowflakeURLBuilder builder) {
        this.url = builder.url;
        this.ssl = builder.ssl;
        this.account = builder.account;
        this.port = builder.port;
        this.jdbcUrl = "jdbc:snowflake://" + builder.url + ":" + builder.port;
    }

    public SnowflakeURL(String urlStr) {
        Pattern pattern = Pattern.compile("^(https?://)?((([\\w\\d-]+)(\\.[\\w\\d-]+){2,})(:(\\d+))?)/?$");
        Matcher matcher = pattern.matcher(urlStr.trim().toLowerCase());
        if (!matcher.find()) {
            throw new SFException(ErrorCode.INVALID_URL, new Object[0]);
        }
        this.ssl = !"http://".equals(matcher.group(1));
        this.url = matcher.group(3);
        this.account = matcher.group(4);
        this.port = matcher.group(7) != null ? Integer.parseInt(matcher.group(7)) : (this.ssl ? 443 : 80);
        this.jdbcUrl = "jdbc:snowflake://" + this.url + ":" + this.port;
        logger.logDebug("parsed Snowflake URL={}", urlStr);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getAccount() {
        return this.account;
    }

    public boolean sslEnabled() {
        return this.ssl;
    }

    public String getScheme() {
        if (this.ssl) {
            return "https";
        }
        return "http";
    }

    public String getFullUrl() {
        return this.url + ":" + this.port;
    }

    public String getUrlWithoutPort() {
        return this.url;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getFullUrl();
    }

    public static class SnowflakeURLBuilder {
        private String url;
        private boolean ssl;
        private String account;
        private int port;

        public SnowflakeURLBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public SnowflakeURLBuilder setSsl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public SnowflakeURLBuilder setAccount(String account) {
            this.account = account;
            return this;
        }

        public SnowflakeURLBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public SnowflakeURL build() {
            return new SnowflakeURL(this);
        }
    }
}

