/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadFactoryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadFactoryUtil.class);

    public static ThreadFactory poolThreadFactory(final String threadBaseName, final boolean isDaemon) {
        return new ThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName(threadBaseName + "-" + this.count.incrementAndGet() + "(" + thread.getId() + ")");
                thread.setDaemon(isDaemon);
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (t2, e) -> LOGGER.error("uncaughtException in thread: " + t2, e);
                thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                return thread;
            }
        };
    }
}

