/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.re2j;

import net.snowflake.client.jdbc.internal.google.re2j.Inst;
import net.snowflake.client.jdbc.internal.google.re2j.Prog;
import net.snowflake.client.jdbc.internal.google.re2j.Regexp;
import net.snowflake.client.jdbc.internal.google.re2j.Unicode;

class Compiler {
    private final Prog prog = new Prog();
    private static final int[] ANY_RUNE_NOT_NL = new int[]{0, 9, 11, 0x10FFFF};
    private static final int[] ANY_RUNE = new int[]{0, 0x10FFFF};

    private Compiler() {
        this.newInst(5);
    }

    static Prog compileRegexp(Regexp re) {
        Compiler c = new Compiler();
        Frag f = c.compile(re);
        c.prog.patch(f.out, c.newInst((int)6).i);
        c.prog.start = f.i;
        return c.prog;
    }

    private Frag newInst(int op) {
        this.prog.addInst(op);
        return new Frag(this.prog.numInst() - 1);
    }

    private Frag nop() {
        Frag f = this.newInst(7);
        f.out = f.i << 1;
        return f;
    }

    private Frag fail() {
        return new Frag();
    }

    private Frag cap(int arg) {
        Frag f = this.newInst(3);
        f.out = f.i << 1;
        this.prog.getInst((int)f.i).arg = arg;
        if (this.prog.numCap < arg + 1) {
            this.prog.numCap = arg + 1;
        }
        return f;
    }

    private Frag cat(Frag f1, Frag f2) {
        if (f1.i == 0 || f2.i == 0) {
            return this.fail();
        }
        this.prog.patch(f1.out, f2.i);
        return new Frag(f1.i, f2.out);
    }

    private Frag alt(Frag f1, Frag f2) {
        if (f1.i == 0) {
            return f2;
        }
        if (f2.i == 0) {
            return f1;
        }
        Frag f = this.newInst(1);
        Inst i = this.prog.getInst(f.i);
        i.out = f1.i;
        i.arg = f2.i;
        f.out = this.prog.append(f1.out, f2.out);
        return f;
    }

    private Frag quest(Frag f1, boolean nongreedy) {
        Frag f = this.newInst(1);
        Inst i = this.prog.getInst(f.i);
        if (nongreedy) {
            i.arg = f1.i;
            f.out = f.i << 1;
        } else {
            i.out = f1.i;
            f.out = f.i << 1 | 1;
        }
        f.out = this.prog.append(f.out, f1.out);
        return f;
    }

    private Frag star(Frag f1, boolean nongreedy) {
        Frag f = this.newInst(1);
        Inst i = this.prog.getInst(f.i);
        if (nongreedy) {
            i.arg = f1.i;
            f.out = f.i << 1;
        } else {
            i.out = f1.i;
            f.out = f.i << 1 | 1;
        }
        this.prog.patch(f1.out, f.i);
        return f;
    }

    private Frag plus(Frag f1, boolean nongreedy) {
        return new Frag(f1.i, this.star((Frag)f1, (boolean)nongreedy).out);
    }

    private Frag empty(int op) {
        Frag f = this.newInst(4);
        this.prog.getInst((int)f.i).arg = op;
        f.out = f.i << 1;
        return f;
    }

    private Frag rune(int rune, int flags) {
        return this.rune(new int[]{rune}, flags);
    }

    private Frag rune(int[] runes, int flags) {
        Frag f = this.newInst(8);
        Inst i = this.prog.getInst(f.i);
        i.runes = runes;
        flags &= 1;
        if (runes.length != 1 || Unicode.simpleFold(runes[0]) == runes[0]) {
            flags &= 0xFFFFFFFE;
        }
        i.arg = flags;
        f.out = f.i << 1;
        if ((flags & 1) == 0 && runes.length == 1 || runes.length == 2 && runes[0] == runes[1]) {
            i.op = 9;
        } else if (runes.length == 2 && runes[0] == 0 && runes[1] == 0x10FFFF) {
            i.op = 10;
        } else if (runes.length == 4 && runes[0] == 0 && runes[1] == 9 && runes[2] == 11 && runes[3] == 0x10FFFF) {
            i.op = 11;
        }
        return f;
    }

    private Frag compile(Regexp re) {
        switch (re.op) {
            case NO_MATCH: {
                return this.fail();
            }
            case EMPTY_MATCH: {
                return this.nop();
            }
            case LITERAL: {
                if (re.runes.length == 0) {
                    return this.nop();
                }
                Frag f = null;
                for (int r : re.runes) {
                    Frag f1 = this.rune(r, re.flags);
                    f = f == null ? f1 : this.cat(f, f1);
                }
                return f;
            }
            case CHAR_CLASS: {
                return this.rune(re.runes, re.flags);
            }
            case ANY_CHAR_NOT_NL: {
                return this.rune(ANY_RUNE_NOT_NL, 0);
            }
            case ANY_CHAR: {
                return this.rune(ANY_RUNE, 0);
            }
            case BEGIN_LINE: {
                return this.empty(1);
            }
            case END_LINE: {
                return this.empty(2);
            }
            case BEGIN_TEXT: {
                return this.empty(4);
            }
            case END_TEXT: {
                return this.empty(8);
            }
            case WORD_BOUNDARY: {
                return this.empty(16);
            }
            case NO_WORD_BOUNDARY: {
                return this.empty(32);
            }
            case CAPTURE: {
                Frag bra = this.cap(re.cap << 1);
                Frag sub = this.compile(re.subs[0]);
                Frag ket = this.cap(re.cap << 1 | 1);
                return this.cat(this.cat(bra, sub), ket);
            }
            case STAR: {
                return this.star(this.compile(re.subs[0]), (re.flags & 0x20) != 0);
            }
            case PLUS: {
                return this.plus(this.compile(re.subs[0]), (re.flags & 0x20) != 0);
            }
            case QUEST: {
                return this.quest(this.compile(re.subs[0]), (re.flags & 0x20) != 0);
            }
            case CONCAT: {
                if (re.subs.length == 0) {
                    return this.nop();
                }
                Frag f = null;
                for (Regexp sub : re.subs) {
                    Frag f1 = this.compile(sub);
                    f = f == null ? f1 : this.cat(f, f1);
                }
                return f;
            }
            case ALTERNATE: {
                if (re.subs.length == 0) {
                    return this.nop();
                }
                Frag f = null;
                for (Regexp sub : re.subs) {
                    Frag f1 = this.compile(sub);
                    f = f == null ? f1 : this.alt(f, f1);
                }
                return f;
            }
        }
        throw new IllegalStateException("regexp: unhandled case in compile");
    }

    private static class Frag {
        final int i;
        int out;

        Frag() {
            this(0, 0);
        }

        Frag(int i) {
            this(i, 0);
        }

        Frag(int i, int out) {
            this.i = i;
            this.out = out;
        }
    }
}

