/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts.internal;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Optional;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.HandshakerReq;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.HandshakerResp;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.HandshakerServiceGrpc;
import net.snowflake.client.jdbc.internal.grpc.stub.StreamObserver;

class AltsHandshakerStub {
    private final StreamObserver<HandshakerResp> reader = new Reader();
    private StreamObserver<HandshakerReq> writer;
    private final HandshakerServiceGrpc.HandshakerServiceStub serviceStub;
    private final ArrayBlockingQueue<Optional<HandshakerResp>> responseQueue = new ArrayBlockingQueue(1);
    private final AtomicReference<String> exceptionMessage = new AtomicReference();
    private static final long HANDSHAKE_RPC_DEADLINE_SECS = 20L;

    AltsHandshakerStub(HandshakerServiceGrpc.HandshakerServiceStub serviceStub) {
        this.serviceStub = serviceStub;
    }

    @VisibleForTesting
    AltsHandshakerStub() {
        this.serviceStub = null;
    }

    @VisibleForTesting
    AltsHandshakerStub(StreamObserver<HandshakerReq> writer) {
        this.writer = writer;
        this.serviceStub = null;
    }

    @VisibleForTesting
    StreamObserver<HandshakerResp> getReaderForTest() {
        return this.reader;
    }

    public HandshakerResp send(HandshakerReq req) throws InterruptedException, IOException {
        this.createWriterIfNull();
        this.maybeThrowIoException();
        if (!this.responseQueue.isEmpty()) {
            throw new IOException("Received an unexpected response.");
        }
        this.writer.onNext(req);
        Optional<HandshakerResp> result = this.responseQueue.take();
        if (result.isPresent()) {
            return result.get();
        }
        if (this.exceptionMessage.get() != null) {
            throw new IOException(this.exceptionMessage.get());
        }
        throw new IOException("No handshaker response received");
    }

    private void createWriterIfNull() {
        if (this.writer == null) {
            this.writer = ((HandshakerServiceGrpc.HandshakerServiceStub)this.serviceStub.withDeadlineAfter(20L, TimeUnit.SECONDS)).doHandshake(this.reader);
        }
    }

    private void maybeThrowIoException() throws IOException {
        if (this.exceptionMessage.get() != null) {
            throw new IOException(this.exceptionMessage.get());
        }
    }

    public void close() {
        if (this.writer != null) {
            this.writer.onCompleted();
        }
    }

    private class Reader
    implements StreamObserver<HandshakerResp> {
        private Reader() {
        }

        @Override
        public void onNext(HandshakerResp resp) {
            try {
                AltsHandshakerStub.this.responseQueue.add(Optional.of(resp));
            }
            catch (IllegalStateException e) {
                AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, "Received an unexpected response.");
                AltsHandshakerStub.this.close();
            }
        }

        @Override
        public void onError(Throwable t2) {
            AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, "Received a terminating error: " + t2.toString());
            Optional result = Optional.absent();
            AltsHandshakerStub.this.responseQueue.offer(result);
        }

        @Override
        public void onCompleted() {
            AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, "Response stream closed.");
            Optional result = Optional.absent();
            AltsHandshakerStub.this.responseQueue.offer(result);
        }
    }
}

