/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityStateInfo;
import net.snowflake.client.jdbc.internal.grpc.Deadline;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.services.MetricReport;
import net.snowflake.client.jdbc.internal.grpc.util.ForwardingLoadBalancerHelper;
import net.snowflake.client.jdbc.internal.grpc.util.ForwardingSubchannel;
import net.snowflake.client.jdbc.internal.grpc.util.RoundRobinLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.orca.OrcaOobUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.orca.OrcaPerRequestUtil;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9885")
final class WeightedRoundRobinLoadBalancer
extends RoundRobinLoadBalancer {
    private static final Logger log = Logger.getLogger(WeightedRoundRobinLoadBalancer.class.getName());
    private WeightedRoundRobinLoadBalancerConfig config;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private SynchronizationContext.ScheduledHandle weightUpdateTimer;
    private final Runnable updateWeightTask;
    private final AtomicInteger sequence;
    private final long infTime;
    private final Deadline.Ticker ticker;

    public WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, new Random());
    }

    public WeightedRoundRobinLoadBalancer(WrrHelper helper, Deadline.Ticker ticker, Random random) {
        super(helper);
        helper.setLoadBalancer(this);
        this.ticker = Preconditions.checkNotNull(ticker, "ticker");
        this.infTime = ticker.nanoTime() + Long.MAX_VALUE;
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        this.updateWeightTask = new UpdateWeightTask();
        this.sequence = new AtomicInteger(random.nextInt());
        log.log(Level.FINE, "weighted_round_robin LB created");
    }

    @VisibleForTesting
    WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker, Random random) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, random);
    }

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (resolvedAddresses.getLoadBalancingPolicyConfig() == null) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("NameResolver returned no WeightedRoundRobinLoadBalancerConfig. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes()));
            return false;
        }
        this.config = (WeightedRoundRobinLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        boolean accepted = super.acceptResolvedAddresses(resolvedAddresses);
        if (this.weightUpdateTimer != null && this.weightUpdateTimer.isPending()) {
            this.weightUpdateTimer.cancel();
        }
        this.updateWeightTask.run();
        this.afterAcceptAddresses();
        return accepted;
    }

    @Override
    public RoundRobinLoadBalancer.RoundRobinPicker createReadyPicker(List<LoadBalancer.Subchannel> activeList) {
        return new WeightedRoundRobinPicker(activeList, this.config.enableOobLoadReport, this.config.errorUtilizationPenalty);
    }

    private void afterAcceptAddresses() {
        for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
            WrrSubchannel weightedSubchannel = (WrrSubchannel)subchannel;
            if (this.config.enableOobLoadReport) {
                WrrSubchannel wrrSubchannel = weightedSubchannel;
                Objects.requireNonNull(wrrSubchannel);
                OrcaOobUtil.setListener(weightedSubchannel, wrrSubchannel.new WrrSubchannel.OrcaReportListener(this.config.errorUtilizationPenalty), OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(this.config.oobReportingPeriodNanos, TimeUnit.NANOSECONDS).build());
                continue;
            }
            OrcaOobUtil.setListener(weightedSubchannel, null, null);
        }
    }

    @Override
    public void shutdown() {
        if (this.weightUpdateTimer != null) {
            this.weightUpdateTimer.cancel();
        }
        super.shutdown();
    }

    static final class WeightedRoundRobinLoadBalancerConfig {
        final long blackoutPeriodNanos;
        final long weightExpirationPeriodNanos;
        final boolean enableOobLoadReport;
        final long oobReportingPeriodNanos;
        final long weightUpdatePeriodNanos;
        final float errorUtilizationPenalty;

        public static Builder newBuilder() {
            return new Builder();
        }

        private WeightedRoundRobinLoadBalancerConfig(long blackoutPeriodNanos, long weightExpirationPeriodNanos, boolean enableOobLoadReport, long oobReportingPeriodNanos, long weightUpdatePeriodNanos, float errorUtilizationPenalty) {
            this.blackoutPeriodNanos = blackoutPeriodNanos;
            this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
            this.enableOobLoadReport = enableOobLoadReport;
            this.oobReportingPeriodNanos = oobReportingPeriodNanos;
            this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
        }

        static final class Builder {
            long blackoutPeriodNanos = 10000000000L;
            long weightExpirationPeriodNanos = 180000000000L;
            boolean enableOobLoadReport = false;
            long oobReportingPeriodNanos = 10000000000L;
            long weightUpdatePeriodNanos = 1000000000L;
            float errorUtilizationPenalty = 1.0f;

            private Builder() {
            }

            Builder setBlackoutPeriodNanos(long blackoutPeriodNanos) {
                this.blackoutPeriodNanos = blackoutPeriodNanos;
                return this;
            }

            Builder setWeightExpirationPeriodNanos(long weightExpirationPeriodNanos) {
                this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
                return this;
            }

            Builder setEnableOobLoadReport(boolean enableOobLoadReport) {
                this.enableOobLoadReport = enableOobLoadReport;
                return this;
            }

            Builder setOobReportingPeriodNanos(long oobReportingPeriodNanos) {
                this.oobReportingPeriodNanos = oobReportingPeriodNanos;
                return this;
            }

            Builder setWeightUpdatePeriodNanos(long weightUpdatePeriodNanos) {
                this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
                return this;
            }

            Builder setErrorUtilizationPenalty(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
                return this;
            }

            WeightedRoundRobinLoadBalancerConfig build() {
                return new WeightedRoundRobinLoadBalancerConfig(this.blackoutPeriodNanos, this.weightExpirationPeriodNanos, this.enableOobLoadReport, this.oobReportingPeriodNanos, this.weightUpdatePeriodNanos, this.errorUtilizationPenalty);
            }
        }
    }

    @VisibleForTesting
    static final class StaticStrideScheduler {
        private final short[] scaledWeights;
        private final AtomicInteger sequence;
        private static final int K_MAX_WEIGHT = 65535;
        private static final double K_MAX_RATIO = 10.0;
        private static final double K_MIN_RATIO = 0.1;

        StaticStrideScheduler(float[] weights, AtomicInteger sequence) {
            double unscaledMeanWeight;
            Preconditions.checkArgument(weights.length >= 1, "Couldn't build scheduler: requires at least one weight");
            int numChannels = weights.length;
            int numWeightedChannels = 0;
            double sumWeight = 0.0;
            float unscaledMaxWeight = 0.0f;
            for (float weight : weights) {
                if (!(weight > 0.0f)) continue;
                sumWeight += (double)weight;
                unscaledMaxWeight = Math.max(weight, unscaledMaxWeight);
                ++numWeightedChannels;
            }
            if (numWeightedChannels > 0) {
                unscaledMeanWeight = sumWeight / (double)numWeightedChannels;
                unscaledMaxWeight = Math.min(unscaledMaxWeight, (float)(10.0 * unscaledMeanWeight));
            } else {
                unscaledMeanWeight = 1.0;
                unscaledMaxWeight = 1.0f;
            }
            double scalingFactor = 65535.0f / unscaledMaxWeight;
            int weightLowerBound = (int)Math.ceil(scalingFactor * unscaledMeanWeight * 0.1);
            short[] scaledWeights = new short[numChannels];
            for (int i = 0; i < numChannels; ++i) {
                if (weights[i] <= 0.0f) {
                    scaledWeights[i] = (short)Math.round(scalingFactor * unscaledMeanWeight);
                    continue;
                }
                int weight = (int)Math.round(scalingFactor * (double)Math.min(weights[i], unscaledMaxWeight));
                scaledWeights[i] = (short)Math.max(weight, weightLowerBound);
            }
            this.scaledWeights = scaledWeights;
            this.sequence = sequence;
        }

        private long nextSequence() {
            return Integer.toUnsignedLong(this.sequence.getAndIncrement());
        }

        int pick() {
            long offset;
            long generation;
            int backendIndex;
            int weight;
            do {
                long sequence = this.nextSequence();
                backendIndex = (int)(sequence % (long)this.scaledWeights.length);
                generation = sequence / (long)this.scaledWeights.length;
            } while (((long)(weight = Short.toUnsignedInt(this.scaledWeights[backendIndex])) * generation + (offset = 32767L * (long)backendIndex)) % 65535L < (long)(65535 - weight));
            return backendIndex;
        }
    }

    @VisibleForTesting
    final class WeightedRoundRobinPicker
    extends RoundRobinLoadBalancer.RoundRobinPicker {
        private final List<LoadBalancer.Subchannel> list;
        private final Map<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener> subchannelToReportListenerMap = new HashMap<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener>();
        private final boolean enableOobLoadReport;
        private final float errorUtilizationPenalty;
        private volatile StaticStrideScheduler scheduler;

        WeightedRoundRobinPicker(List<LoadBalancer.Subchannel> list, boolean enableOobLoadReport, float errorUtilizationPenalty) {
            Preconditions.checkNotNull(list, "list");
            Preconditions.checkArgument(!list.isEmpty(), "empty list");
            this.list = list;
            for (LoadBalancer.Subchannel subchannel : list) {
                WrrSubchannel wrrSubchannel = (WrrSubchannel)subchannel;
                Objects.requireNonNull(wrrSubchannel);
                this.subchannelToReportListenerMap.put(subchannel, wrrSubchannel.new WrrSubchannel.OrcaReportListener(errorUtilizationPenalty));
            }
            this.enableOobLoadReport = enableOobLoadReport;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
            this.updateWeight();
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            LoadBalancer.Subchannel subchannel = this.list.get(this.scheduler.pick());
            if (!this.enableOobLoadReport) {
                OrcaPerRequestUtil orcaPerRequestUtil = OrcaPerRequestUtil.getInstance();
                WrrSubchannel wrrSubchannel = (WrrSubchannel)subchannel;
                Objects.requireNonNull(wrrSubchannel);
                return LoadBalancer.PickResult.withSubchannel(subchannel, orcaPerRequestUtil.newOrcaClientStreamTracerFactory(this.subchannelToReportListenerMap.getOrDefault(subchannel, wrrSubchannel.new WrrSubchannel.OrcaReportListener(this.errorUtilizationPenalty))));
            }
            return LoadBalancer.PickResult.withSubchannel(subchannel);
        }

        private void updateWeight() {
            float[] newWeights = new float[this.list.size()];
            for (int i = 0; i < this.list.size(); ++i) {
                WrrSubchannel subchannel = (WrrSubchannel)this.list.get(i);
                double newWeight = subchannel.getWeight();
                newWeights[i] = newWeight > 0.0 ? (float)newWeight : 0.0f;
            }
            this.scheduler = new StaticStrideScheduler(newWeights, WeightedRoundRobinLoadBalancer.this.sequence);
        }

        public String toString() {
            return MoreObjects.toStringHelper(WeightedRoundRobinPicker.class).add("enableOobLoadReport", this.enableOobLoadReport).add("errorUtilizationPenalty", this.errorUtilizationPenalty).add("list", this.list).toString();
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        @Override
        public boolean isEquivalentTo(RoundRobinLoadBalancer.RoundRobinPicker picker) {
            if (!(picker instanceof WeightedRoundRobinPicker)) {
                return false;
            }
            WeightedRoundRobinPicker other = (WeightedRoundRobinPicker)picker;
            if (other == this) {
                return true;
            }
            return this.enableOobLoadReport == other.enableOobLoadReport && Float.compare(this.errorUtilizationPenalty, other.errorUtilizationPenalty) == 0 && this.list.size() == other.list.size() && new HashSet<LoadBalancer.Subchannel>(this.list).containsAll(other.list);
        }
    }

    @VisibleForTesting
    final class WrrSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private volatile long lastUpdated;
        private volatile long nonEmptySince;
        private volatile double weight;

        WrrSubchannel(LoadBalancer.Subchannel delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        }

        @Override
        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.delegate().start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (newState.getState().equals((Object)ConnectivityState.READY)) {
                        WrrSubchannel.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                    }
                    listener.onSubchannelState(newState);
                }
            });
        }

        private double getWeight() {
            if (WeightedRoundRobinLoadBalancer.this.config == null) {
                return 0.0;
            }
            long now = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
            if (now - this.lastUpdated >= ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightExpirationPeriodNanos) {
                this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                return 0.0;
            }
            if (now - this.nonEmptySince < ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos && ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos > 0L) {
                return 0.0;
            }
            return this.weight;
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        final class OrcaReportListener
        implements OrcaPerRequestUtil.OrcaPerRequestReportListener,
        OrcaOobUtil.OrcaOobReportListener {
            private final float errorUtilizationPenalty;

            OrcaReportListener(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
            }

            @Override
            public void onLoadReport(MetricReport report) {
                double utilization;
                double newWeight = 0.0;
                double d = utilization = report.getApplicationUtilization() > 0.0 ? report.getApplicationUtilization() : report.getCpuUtilization();
                if (utilization > 0.0 && report.getQps() > 0.0) {
                    double penalty = 0.0;
                    if (report.getEps() > 0.0 && this.errorUtilizationPenalty > 0.0f) {
                        penalty = report.getEps() / report.getQps() * (double)this.errorUtilizationPenalty;
                    }
                    newWeight = report.getQps() / (utilization + penalty);
                }
                if (newWeight == 0.0) {
                    return;
                }
                if (WrrSubchannel.this.nonEmptySince == WeightedRoundRobinLoadBalancer.this.infTime) {
                    WrrSubchannel.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                }
                WrrSubchannel.this.lastUpdated = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                WrrSubchannel.this.weight = newWeight;
            }
        }
    }

    private static final class WrrHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private WeightedRoundRobinLoadBalancer wrr;

        WrrHelper(LoadBalancer.Helper helper) {
            this.delegate = helper;
        }

        void setLoadBalancer(WeightedRoundRobinLoadBalancer lb) {
            this.wrr = lb;
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            WeightedRoundRobinLoadBalancer weightedRoundRobinLoadBalancer = this.wrr;
            Objects.requireNonNull(weightedRoundRobinLoadBalancer);
            return weightedRoundRobinLoadBalancer.new WrrSubchannel(this.delegate().createSubchannel(args));
        }
    }

    private final class UpdateWeightTask
    implements Runnable {
        private UpdateWeightTask() {
        }

        @Override
        public void run() {
            if (WeightedRoundRobinLoadBalancer.this.currentPicker != null && WeightedRoundRobinLoadBalancer.this.currentPicker instanceof WeightedRoundRobinPicker) {
                ((WeightedRoundRobinPicker)WeightedRoundRobinLoadBalancer.this.currentPicker).updateWeight();
            }
            WeightedRoundRobinLoadBalancer.this.weightUpdateTimer = WeightedRoundRobinLoadBalancer.this.syncContext.schedule(this, ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightUpdatePeriodNanos, TimeUnit.NANOSECONDS, WeightedRoundRobinLoadBalancer.this.timeService);
        }
    }
}

