/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFJsonResultSet
extends SFBaseResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFJsonResultSet.class);
    protected final TimeZone sessionTimeZone;
    protected final Converters converters;

    protected SFJsonResultSet(TimeZone sessionTimeZone, Converters converters) {
        this.sessionTimeZone = sessionTimeZone;
        this.converters = converters;
    }

    protected abstract Object getObjectInternal(int var1) throws SFException;

    @Override
    public Object getObject(int columnIndex) throws SFException {
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getBigInt(columnIndex, obj);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type);
    }

    private Object getBigInt(int columnIndex, Object obj) throws SFException {
        return this.converters.getNumberConverter().getBigInt(obj, columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SFException {
        logger.debug("public String getString(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getStringConverter().getString(obj, columnType, columnSubType, scale);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SFException {
        logger.debug("public boolean getBoolean(int columnIndex)", false);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getBooleanConverter().getBoolean(this.getObjectInternal(columnIndex), columnType);
    }

    @Override
    public byte getByte(int columnIndex) throws SFException {
        logger.debug("public short getByte(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        return this.converters.getNumberConverter().getByte(obj);
    }

    @Override
    public short getShort(int columnIndex) throws SFException {
        logger.debug("public short getShort(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getShort(obj, columnType);
    }

    @Override
    public int getInt(int columnIndex) throws SFException {
        logger.debug("public int getInt(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getInt(obj, columnType);
    }

    @Override
    public long getLong(int columnIndex) throws SFException {
        logger.debug("public long getLong(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getLong(obj, columnType);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getBigDecimal(obj, columnType);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getBigDecimal(obj, columnType, scale);
    }

    @Override
    public Time getTime(int columnIndex) throws SFException {
        logger.debug("public Time getTime(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getDateTimeConverter().getTime(obj, columnType, columnSubType, TimeZone.getDefault(), scale);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getDateTimeConverter().getTimestamp(obj, columnType, columnSubType, tz, scale);
    }

    @Override
    public float getFloat(int columnIndex) throws SFException {
        logger.debug("public float getFloat(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getFloat(obj, columnType);
    }

    @Override
    public double getDouble(int columnIndex) throws SFException {
        logger.debug("public double getDouble(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        return this.converters.getNumberConverter().getDouble(obj, columnType);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SFException {
        logger.debug("public byte[] getBytes(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getBytesConverter().getBytes(obj, columnType, columnSubType, scale);
    }

    public Date getDate(int columnIndex) throws SFException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        logger.debug("public Date getDate(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        int columnSubType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return this.converters.getDateTimeConverter().getDate(obj, columnType, columnSubType, tz, scale);
    }

    private Timestamp getTimestamp(int columnIndex) throws SFException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }
}

