/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.util.Date;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.Secret;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

public class ClientCredentialsParser {
    public static ClientID parseID(JSONObject jsonObject) throws ParseException {
        return new ClientID(JSONObjectUtils.getNonBlankString(jsonObject, "client_id"));
    }

    public static Date parseIDIssueDate(JSONObject jsonObject) throws ParseException {
        if (jsonObject.containsKey("client_id_issued_at")) {
            return new Date(JSONObjectUtils.getLong(jsonObject, "client_id_issued_at") * 1000L);
        }
        return null;
    }

    public static Secret parseSecret(JSONObject jsonObject) throws ParseException {
        if (jsonObject.containsKey("client_secret")) {
            long t2;
            String value = JSONObjectUtils.getNonBlankString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey("client_secret_expires_at") && (t2 = JSONObjectUtils.getLong(jsonObject, "client_secret_expires_at")) > 0L) {
                exp = new Date(t2 * 1000L);
            }
            return new Secret(value, exp);
        }
        return null;
    }

    public static URI parseRegistrationURI(JSONObject jsonObject) throws ParseException {
        return JSONObjectUtils.getURI(jsonObject, "registration_client_uri", null);
    }

    public static BearerAccessToken parseRegistrationAccessToken(JSONObject jsonObject) throws ParseException {
        if (jsonObject.containsKey("registration_access_token")) {
            return new BearerAccessToken(JSONObjectUtils.getNonBlankString(jsonObject, "registration_access_token"));
        }
        return null;
    }
}

