/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PartETag;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartResult;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.StorageInfo$;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=f!\u0002\u0014(\u0001\u001d\u0002\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aq\r\u0001B\u0001B\u0003%q\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\u000fY\u0004\u0001\u0019!C\u0005o\"1Q\u0010\u0001Q!\nMDqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!9\u0011q\u0001\u0001!B\u0013\u0019\u0007\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002&\u0001\u0001\u000b\u0015BA\r\u0011%\t9\u0003\u0001a\u0001\n\u0013\t9\u0002C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,!A\u0011q\u0006\u0001!B\u0013\tI\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024!A\u0011q\t\u0001!\u0002\u0013\t)\u0004\u0003\u0005\u0002J\u0001\u0001\r\u0011\"\u0003\u0000\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0005C\u0004\u0002R\u0001\u0001\u000b\u0015B2\t\u0013\u0005M\u0003A1A\u0005\n\u0005U\u0003bBA,\u0001\u0001\u0006Ia\u0018\u0005\n\u00033\u0002!\u0019!C\u0005\u00037B\u0001\"a\u001a\u0001A\u0003%\u0011Q\f\u0005\u000b\u0003S\u0002\u0001R1A\u0005\n\u0005-\u0004BCA:\u0001!\u0015\r\u0011\"\u0003\u0002v!A\u0011Q\u0010\u0001\u0005\u0002\u001d\ny\bC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bBAM\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003[\u0003A\u0011IAL\u0005Q\u00196'\u00169m_\u0006$w*\u001e;qkR\u001cFO]3b[*\u0011\u0001&K\u0001\u0003S>T!AK\u0016\u0002\u0013Mtwn\u001e4mC.,'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tQcFC\u00010\u0003\rqW\r^\n\u0003\u0001E\u0002\"A\r\u001c\u000e\u0003MR!\u0001\u000b\u001b\u000b\u0003U\nAA[1wC&\u0011qg\r\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\tgN\u001aE.[3oi\u000e\u0001\u0001CA\u001eI\u001b\u0005a$BA\u001f?\u0003\t\u00198G\u0003\u0002@\u0001\u0006A1/\u001a:wS\u000e,7O\u0003\u0002B\u0005\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0003\u0007\u0012\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u001a\u000bAA\u001b3cG*\u0011q)L\u0001\u0007G2LWM\u001c;\n\u0005%c$\u0001C!nCj|gnU\u001a\u0002\t5,G/\u0019\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dr\nQ!\\8eK2L!\u0001U'\u0003\u001d=\u0013'.Z2u\u001b\u0016$\u0018\rZ1uC\u0006Y1\u000f^8sC\u001e,\u0017J\u001c4p!\u0011\u0019FlX0\u000f\u0005QS\u0006CA+Y\u001b\u00051&BA,:\u0003\u0019a$o\\8u})\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\u00061\u0001K]3eK\u001aL!!\u00180\u0003\u00075\u000b\u0007O\u0003\u0002\\1B\u00111\u000bY\u0005\u0003Cz\u0013aa\u0015;sS:<\u0017A\u00032vM\u001a,'oU5{KB\u0011A-Z\u0007\u00021&\u0011a\r\u0017\u0002\u0004\u0013:$\u0018\u0001\u00024jY\u0016\fa\u0001P5oSRtDC\u00026m[:|\u0007\u000f\u0005\u0002l\u00015\tq\u0005C\u00039\r\u0001\u0007!\bC\u0003K\r\u0001\u00071\nC\u0003R\r\u0001\u0007!\u000bC\u0003c\r\u0001\u00071\rC\u0003h\r\u0001\u0007q,\u0001\fvg\u0016lU\u000f\u001c;ja2,'\t\\8dWV\u0003Hn\\1e+\u0005\u0019\bC\u00013u\u0013\t)\bLA\u0004C_>dW-\u00198\u00025U\u001cX-T;mi&\u0004H.\u001a\"m_\u000e\\W\u000b\u001d7pC\u0012|F%Z9\u0015\u0005a\\\bC\u00013z\u0013\tQ\bL\u0001\u0003V]&$\bb\u0002?\t\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\n\u0014aF;tK6+H\u000e^5qY\u0016\u0014En\\2l+Bdw.\u00193!\u0003A!\u0017\r^1TSj,\u0017J\u001c\"vM\u001a,'/F\u0001d\u0003Q!\u0017\r^1TSj,\u0017J\u001c\"vM\u001a,'o\u0018\u0013fcR\u0019\u00010!\u0002\t\u000fq\\\u0011\u0011!a\u0001G\u0006\tB-\u0019;b'&TX-\u00138Ck\u001a4WM\u001d\u0011\u0002+\tLH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[V\u0011\u0011Q\u0002\t\u0004e\u0005=\u0011bAA\tg\t)\")\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l\u0017A\u00062zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0011\u0002\u001bQ|G/\u00197ECR\f7+\u001b>f+\t\tI\u0002E\u0002e\u00037I1!!\bY\u0005\u0011auN\\4\u0002#Q|G/\u00197ECR\f7+\u001b>f?\u0012*\u0017\u000fF\u0002y\u0003GA\u0001\u0002 \t\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u000fi>$\u0018\r\u001c#bi\u0006\u001c\u0016N_3!\u0003=!x\u000e^1m+Bdw.\u00193US6,\u0017a\u0005;pi\u0006dW\u000b\u001d7pC\u0012$\u0016.\\3`I\u0015\fHc\u0001=\u0002.!AApEA\u0001\u0002\u0004\tI\"\u0001\tu_R\fG.\u00169m_\u0006$G+[7fA\u0005I\u0001/\u0019:u\u000bR\u000bwm]\u000b\u0003\u0003k\u0001b!a\u000e\u0002>\u0005\u0005SBAA\u001d\u0015\r\tY\u0004N\u0001\u0005kRLG.\u0003\u0003\u0002@\u0005e\"!C!se\u0006LH*[:u!\ra\u00151I\u0005\u0004\u0003\u000bj%\u0001\u0003)beR,E+Y4\u0002\u0015A\f'\u000f^#UC\u001e\u001c\b%\u0001\u0004qCJ$\u0018\nZ\u0001\u000ba\u0006\u0014H/\u00133`I\u0015\fHc\u0001=\u0002P!9A\u0010GA\u0001\u0002\u0004\u0019\u0017a\u00029beRLE\rI\u0001\u000bEV\u001c7.\u001a;OC6,W#A0\u0002\u0017\t,8m[3u\u001d\u0006lW\rI\u0001\bW\u0016Lh*Y7f+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019\u0007N\u0001\u0005Y\u0006tw-C\u0002b\u0003C\n\u0001b[3z\u001d\u0006lW\rI\u0001\fS:LGOU3rk\u0016\u001cH/\u0006\u0002\u0002nA\u0019A*a\u001c\n\u0007\u0005ETJ\u0001\u0010J]&$\u0018.\u0019;f\u001bVdG/\u001b9beR,\u0006\u000f\\8bIJ+\u0017/^3ti\u0006a\u0011N\\5u%\u0016\u001c\bo\u001c8tKV\u0011\u0011q\u000f\t\u0004\u0019\u0006e\u0014bAA>\u001b\ni\u0012J\\5uS\u0006$X-T;mi&\u0004\u0018M\u001d;Va2|\u0017\r\u001a*fgVdG/\u0001\fhKR$\u0015\r^1J]\n+hMZ3s\r>\u0014H+Z:u)\t\t\t\tE\u0003e\u0003\u0007\u000b9)C\u0002\u0002\u0006b\u0013Q!\u0011:sCf\u00042\u0001ZAE\u0013\r\tY\t\u0017\u0002\u0005\u0005f$X-A\bva2|\u0017\r\u001a#bi\u0006\u001c\u0005.\u001e8l)\rA\u0018\u0011\u0013\u0005\u0007\u0003'\u000b\u0003\u0019A:\u0002\u0017%\u001cH*Y:u\u0007\",hn[\u0001\u0010I>,\u0006\u000f\\8bI>sW\rU1siR\t\u00010A\u0003xe&$X\rF\u0002y\u0003;Ca!a($\u0001\u0004\u0019\u0017!\u00012\u0015\u000fa\f\u0019+!*\u0002*\"9\u0011q\u0014\u0013A\u0002\u0005\u0005\u0005BBATI\u0001\u00071-A\u0002pM\u001aDa!a+%\u0001\u0004\u0019\u0017a\u00017f]\u0006)1\r\\8tK\u0002")
public class S3UploadOutputStream
extends OutputStream {
    private InitiateMultipartUploadRequest initRequest;
    private InitiateMultipartUploadResult initResponse;
    private final AmazonS3 s3Client;
    private final ObjectMetadata meta;
    private final int bufferSize;
    private final String file;
    private boolean useMultipleBlockUpload;
    private int dataSizeInBuffer;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private long totalDataSize;
    private long totalUploadTime;
    private final ArrayList<PartETag> partETags;
    private int partId;
    private final String bucketName;
    private final String keyName;
    private volatile byte bitmap$0;

    private boolean useMultipleBlockUpload() {
        return this.useMultipleBlockUpload;
    }

    private void useMultipleBlockUpload_$eq(boolean x$1) {
        this.useMultipleBlockUpload = x$1;
    }

    private int dataSizeInBuffer() {
        return this.dataSizeInBuffer;
    }

    private void dataSizeInBuffer_$eq(int x$1) {
        this.dataSizeInBuffer = x$1;
    }

    private ByteArrayOutputStream byteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    private long totalDataSize() {
        return this.totalDataSize;
    }

    private void totalDataSize_$eq(long x$1) {
        this.totalDataSize = x$1;
    }

    private long totalUploadTime() {
        return this.totalUploadTime;
    }

    private void totalUploadTime_$eq(long x$1) {
        this.totalUploadTime = x$1;
    }

    private ArrayList<PartETag> partETags() {
        return this.partETags;
    }

    private int partId() {
        return this.partId;
    }

    private void partId_$eq(int x$1) {
        this.partId = x$1;
    }

    private String bucketName() {
        return this.bucketName;
    }

    private String keyName() {
        return this.keyName;
    }

    private InitiateMultipartUploadRequest initRequest$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.initRequest = new InitiateMultipartUploadRequest(this.bucketName(), this.keyName(), this.meta);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.initRequest;
    }

    private InitiateMultipartUploadRequest initRequest() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.initRequest$lzycompute();
        }
        return this.initRequest;
    }

    private InitiateMultipartUploadResult initResponse$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initResponse = this.s3Client.initiateMultipartUpload(this.initRequest());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.initResponse;
    }

    private InitiateMultipartUploadResult initResponse() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.initResponse$lzycompute();
        }
        return this.initResponse;
    }

    public byte[] getDataInBufferForTest() {
        return this.byteArrayOutputStream().toByteArray();
    }

    private void uploadDataChunk(boolean isLastChunk) {
        if (isLastChunk && !this.useMultipleBlockUpload()) {
            long start = System.currentTimeMillis();
            this.meta.setContentLength((long)this.dataSizeInBuffer());
            this.byteArrayOutputStream().close();
            byte[] buffer = this.byteArrayOutputStream().toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
            this.s3Client.putObject(this.bucketName(), this.keyName(), (InputStream)inputStream, this.meta);
            long usedTime = System.currentTimeMillis() - start;
            this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
            CloudStorageOperations$.MODULE$.log().info(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(200).append(SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX()).append(":\n           | Finish uploading file ").append(this.file).append(" without AWS multiple parts API\n           | because the data size is less than the buffer size:\n           | bufferSize=").append(Utils$.MODULE$.getSizeString(this.bufferSize)).append("\n           | compressedSize=").append(Utils$.MODULE$.getSizeString(this.dataSizeInBuffer())).append("\n           |").toString()))), (Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)S3UploadOutputStream.$anonfun$uploadDataChunk$1(BoxesRunTime.unboxToChar((Object)x$42)))));
            return;
        }
        this.doUploadOnePart();
        if (isLastChunk) {
            this.byteArrayOutputStream().close();
            long start = System.currentTimeMillis();
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucketName(), this.keyName(), this.initResponse().getUploadId(), this.partETags());
            this.s3Client.completeMultipartUpload(compRequest);
            long usedTime = System.currentTimeMillis() - start;
            this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
            CloudStorageOperations$.MODULE$.log().info(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(153).append(SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX()).append(":\n             | Finish uploading file ").append(this.file).append(" with AWS multiple parts API:\n             | bufferSize=").append(Utils$.MODULE$.getSizeString(this.bufferSize)).append(" chunkCount=").append(this.partId()).append("\n             | compressedSize=").append(Utils$.MODULE$.getSizeString(this.totalDataSize())).append("\n             |").toString()))), (Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)S3UploadOutputStream.$anonfun$uploadDataChunk$2(BoxesRunTime.unboxToChar((Object)x$43)))));
            return;
        }
    }

    private void doUploadOnePart() {
        long start = System.currentTimeMillis();
        this.useMultipleBlockUpload_$eq(true);
        byte[] buffer = this.byteArrayOutputStream().toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
        UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName()).withKey(this.keyName()).withUploadId(this.initResponse().getUploadId()).withPartNumber(this.partId()).withInputStream((InputStream)inputStream).withPartSize((long)this.dataSizeInBuffer());
        UploadPartResult uploadResult = this.s3Client.uploadPart(uploadRequest);
        this.partETags().add(uploadResult.getPartETag());
        this.totalDataSize_$eq(this.totalDataSize() + (long)this.dataSizeInBuffer());
        this.dataSizeInBuffer_$eq(0);
        this.partId_$eq(this.partId() + 1);
        this.byteArrayOutputStream().reset();
        long usedTime = System.currentTimeMillis() - start;
        this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
        if (this.partId() == 3) {
            TestHook$.MODULE$.raiseExceptionIfTestFlagEnabled(TestHookFlag$.MODULE$.TH_FAIL_UPLOAD_AWS_2ND_BLOCK(), "Negative test to raise error after upload 2nd parts");
            return;
        }
    }

    @Override
    public void write(int b) {
        if (this.dataSizeInBuffer() >= this.bufferSize) {
            this.uploadDataChunk(false);
        }
        this.byteArrayOutputStream().write(b);
        this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int partSize;
        int inputSize = len - off;
        if (inputSize + this.dataSizeInBuffer() <= this.bufferSize) {
            this.byteArrayOutputStream().write(b, off, inputSize);
            this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + inputSize);
            return;
        }
        int firstPartSize = this.bufferSize - this.dataSizeInBuffer();
        if (firstPartSize > 0) {
            this.byteArrayOutputStream().write(b, off, firstPartSize);
            this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + firstPartSize);
        }
        int leftLen = len - firstPartSize;
        int newOff = off + firstPartSize;
        do {
            this.uploadDataChunk(false);
            partSize = Math.min(this.bufferSize, leftLen);
            this.byteArrayOutputStream().write(b, newOff, partSize);
            this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + partSize);
            newOff += partSize;
        } while ((leftLen -= partSize) > 0);
    }

    @Override
    public void close() {
        if (this.dataSizeInBuffer() > 0) {
            this.uploadDataChunk(true);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$uploadDataChunk$1(char x$42) {
        return x$42 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$uploadDataChunk$2(char x$43) {
        return x$43 >= ' ';
    }

    public S3UploadOutputStream(AmazonS3 s3Client, ObjectMetadata meta, Map<String, String> storageInfo, int bufferSize, String file) {
        this.s3Client = s3Client;
        this.meta = meta;
        this.bufferSize = bufferSize;
        this.file = file;
        this.useMultipleBlockUpload = false;
        this.dataSizeInBuffer = 0;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.totalDataSize = 0L;
        this.totalUploadTime = 0L;
        this.partETags = new ArrayList();
        this.partId = 1;
        this.bucketName = (String)storageInfo.apply((Object)StorageInfo$.MODULE$.BUCKET_NAME());
        this.keyName = ((String)storageInfo.apply((Object)StorageInfo$.MODULE$.PREFIX())).concat(file);
    }
}

