/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.Serializable;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.streaming.SnowflakeIngestService;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MODULE$.getClass().getName());
    private static final int SLEEP_TIME = 5000;
    private static final int TIME_OUT = 5;
    private static final HashMap<String, SnowflakeIngestService> pipeList = new HashMap();

    private Logger LOGGER() {
        return LOGGER;
    }

    private int SLEEP_TIME() {
        return SLEEP_TIME;
    }

    private int TIME_OUT() {
        return TIME_OUT;
    }

    private HashMap<String, SnowflakeIngestService> pipeList() {
        return pipeList;
    }

    public SnowflakeIngestService openIngestionService(Parameters.MergedParameters param, String pipeName, Enumeration.Value format, StructType schema, CloudStorage storage, ServerConnection conn) {
        this.LOGGER().debug(new StringBuilder(41).append("create new ingestion service, pipe name: ").append(pipeName).toString());
        BooleanRef pipeDropped = BooleanRef.create((boolean)false);
        Future checkPrevious = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            while (MODULE$.pipeList().contains((Object)pipeName)) {
                MODULE$.LOGGER().debug("waiting previous pipe dropped");
                Thread.sleep(MODULE$.SLEEP_TIME());
            }
            MODULE$.LOGGER().debug("previous pipe dropped");
            pipeDropped$1.elem = true;
            return pipeDropped$1.elem;
        }, ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)checkPrevious, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.TIME_OUT())).minutes());
        if (pipeDropped.elem) {
            DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$1 = ((TableName)param.table().get()).name();
            StructType x$2 = schema;
            Parameters.MergedParameters x$3 = param;
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = qual$1.createTable$default$6();
            qual$1.createTable(x$1, x$2, x$3, false, false, x$6);
            SnowflakeSQLStatement copy = new ConstantString(this.copySql(param, conn, format, schema)).$bang();
            if (this.verifyPipe(conn, pipeName, copy.toString())) {
                this.LOGGER().info(new StringBuilder(12).append("reuse pipe: ").append(pipeName).toString());
            } else {
                DefaultJDBCWrapper.DataBaseOperations qual$2 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                String x$7 = pipeName;
                SnowflakeSQLStatement x$8 = copy;
                boolean x$9 = true;
                boolean x$10 = qual$2.createPipe$default$4();
                qual$2.createPipe(x$7, x$8, true, x$10);
            }
            SnowflakeIngestService ingestion = new SnowflakeIngestService(param, pipeName, storage, conn);
            this.pipeList().put((Object)pipeName, (Object)ingestion);
            return ingestion;
        }
        this.LOGGER().error("waiting pipe dropped time out");
        throw new IllegalStateException(new StringBuilder(42).append("Waiting pipe dropped time out, pipe name: ").append(pipeName).toString());
    }

    public void closeIngestionService(String pipeName) {
        this.LOGGER().debug(new StringBuilder(38).append("closing ingestion service, pipe name: ").append(pipeName).toString());
        if (this.pipeList().contains((Object)pipeName)) {
            ((SnowflakeIngestService)this.pipeList().apply((Object)pipeName)).close();
            this.pipeList().remove((Object)pipeName);
            this.LOGGER().debug(new StringBuilder(37).append("ingestion service closed, pipe name: ").append(pipeName).toString());
            return;
        }
        this.LOGGER().error(new StringBuilder(40).append("ingestion service not found, pipe name: ").append(pipeName).toString());
    }

    public void closeAllIngestionService() {
        this.LOGGER().debug("closing ingestion service");
        this.pipeList().foreach((Function1 & Serializable)x$1 -> {
            package$.$anonfun$closeAllIngestionService$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.LOGGER().debug("all ingestion service closed");
    }

    private String copySql(Parameters.MergedParameters param, ServerConnection conn, Enumeration.Value format, StructType schema) {
        String string;
        None$ none$;
        Option<Map<String, String>> option;
        TableName tableName = (TableName)param.table().get();
        String stageName = (String)param.streamingStage().get();
        StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn, tableName.toString(), param);
        String fromString = new StringBuilder(6).append("FROM @").append(stageName).toString();
        if (param.columnMap().isEmpty()) {
            String string2 = param.columnMapping();
            String string3 = "name";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                param.setColumnMap((Option<StructType>)Option$.MODULE$.apply((Object)schema), (Option<StructType>)Option$.MODULE$.apply((Object)tableSchema));
            }
        }
        if ((option = param.columnMap()) instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            none$ = new Some((Object)map.toList().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    try {
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tableSchema.fieldIndex(value)), (Object)key);
                    }
                    catch (Exception e) {
                        MODULE$.LOGGER().error(new StringBuilder(37).append("Error occurred while column mapping: ").append(e).toString());
                        throw e;
                    }
                    return tuple22;
                }
                throw new MatchError((Object)tuple2);
            }));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        None$ mappingList = none$;
        String mappingToString = package$.getMappingToString$1((Option)mappingList, format, conn, tableName, param, tableSchema);
        String mappingFromString = package$.getMappingFromString$1((Option)mappingList, fromString, format, param, tableSchema);
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |FILE_FORMAT = (\n             |    TYPE=CSV\n             |    FIELD_DELIMITER='|'\n             |    NULL_IF=()\n             |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n             |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n             |  )\n           "));
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |FILE_FORMAT = (\n             |    TYPE = JSON\n             |)\n           "));
            } else {
                throw new MatchError((Object)value);
            }
        }
        String formatString = string;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n       |COPY INTO ").append(tableName).append(" ").append(mappingToString).append("\n       |").append(mappingFromString).append("\n       |").append(formatString).append("\n    ").toString())).trim();
    }

    public boolean verifyPipe(ServerConnection conn, String pipeName, String copyStatement) {
        boolean x$2;
        String x$1;
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
        Option<String> option = qual$1.pipeDefinition(x$1 = pipeName, x$2 = qual$1.pipeDefinition$default$2());
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            return str.trim().equals(copyStatement.trim());
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$closeAllIngestionService$1(Tuple2 x$1) {
        ((SnowflakeIngestService)x$1._2()).close();
    }

    private static final String getMappingToString$1(Option list, Enumeration.Value format$1, ServerConnection conn$1, TableName tableName$1, Parameters.MergedParameters param$1, StructType tableSchema$1) {
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType schema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$1, tableName$1.name(), param$1);
            if (list.isEmpty() || ((List)list.get()).isEmpty()) {
                return new StringBuilder(2).append("(").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x -> Utils$.MODULE$.quotedNameIgnoreCase(x.name()), ClassTag$.MODULE$.apply(String.class))).mkString(",")).append(")").toString();
            }
            return new StringBuilder(2).append("(").append(((List)list.get()).map((Function1 & Serializable)x -> Utils$.MODULE$.quotedNameIgnoreCase(tableSchema$1.apply(x._1$mcI$sp()).name())).mkString(", ")).append(")").toString();
        }
        Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            if (list.isEmpty() || ((List)list.get()).isEmpty()) {
                return "";
            }
            return new StringBuilder(2).append("(").append(((List)list.get()).map((Function1 & Serializable)x -> Utils$.MODULE$.quotedNameIgnoreCase((String)x._2())).mkString(", ")).append(")").toString();
        }
        throw new MatchError((Object)value);
    }

    private static final String getMappingFromString$1(Option list, String from, Enumeration.Value format$1, Parameters.MergedParameters param$1, StructType tableSchema$1) {
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            String columnPrefix;
            String string = columnPrefix = param$1.useParseJsonForWrite() ? "parse_json($1):" : "$1:";
            if (list.isEmpty() || ((List)list.get()).isEmpty()) {
                String names = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tableSchema$1.fields()), (Function1 & Serializable)x -> columnPrefix.concat(Utils$.MODULE$.quotedNameIgnoreCase(x.name())), ClassTag$.MODULE$.apply(String.class))).mkString(",");
                return new StringBuilder(19).append("from (select ").append(names).append(" ").append(from).append(" tmp)").toString();
            }
            return new StringBuilder(19).append("from (select ").append(((List)list.get()).map((Function1 & Serializable)x -> columnPrefix.concat(Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()))).mkString(", ")).append(" ").append(from).append(" tmp)").toString();
        }
        Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            if (list.isEmpty() || ((List)list.get()).isEmpty()) {
                return from;
            }
            return new StringBuilder(19).append("from (select ").append(((List)list.get()).map((Function1 & Serializable)x -> "tmp.$".concat(Utils$.MODULE$.quotedNameIgnoreCase(Integer.toString(x._1$mcI$sp() + 1)))).mkString(", ")).append(" ").append(from).append(" tmp)").toString();
        }
        throw new MatchError((Object)value);
    }

    private package$() {
    }
}

