/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import net.snowflake.client.jdbc.internal.apache.commons.codec.binary.Base64;
import net.snowflake.spark.snowflake.Conversions$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ub!B\u0005\u000b\u0001)\t\u0002\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\t\u000by\u0001A\u0011A\u0010\t\u000b\t\u0002A\u0011A\u0012\t\u000by\u0003A\u0011A0\t\u000by\u0004A\u0011B@\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0002\u0010':|wO\u001a7bW\u0016<&/\u001b;fe*\u00111\u0002D\u0001\ng:|wO\u001a7bW\u0016T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005-y!\"\u0001\t\u0002\u00079,Go\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\f1B\u001b3cG^\u0013\u0018\r\u001d9fe\u000e\u0001\u0001CA\u000e\u001d\u001b\u0005Q\u0011BA\u000f\u000b\u0005-QEIQ\"Xe\u0006\u0004\b/\u001a:\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u001c\u0001!)\u0001D\u0001a\u00015\u0005!1/\u0019<f)\u0015!s\u0005\u000e%N!\t\u0019R%\u0003\u0002')\t!QK\\5u\u0011\u0015A3\u00011\u0001*\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003UIj\u0011a\u000b\u0006\u0003Y5\n1a]9m\u0015\tiaF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a,\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006k\r\u0001\rAN\u0001\u0005I\u0006$\u0018\r\u0005\u00028\u000b:\u0011\u0001h\u0011\b\u0003s\ts!AO!\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u001a\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u00020a%\u0011QBL\u0005\u0003Y5J!\u0001R\u0016\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001R\u0016\t\u000b%\u001b\u0001\u0019\u0001&\u0002\u0011M\fg/Z'pI\u0016\u0004\"AK&\n\u00051[#\u0001C*bm\u0016lu\u000eZ3\t\u000b9\u001b\u0001\u0019A(\u0002\rA\f'/Y7t!\t\u00016L\u0004\u0002R3:\u0011!\u000b\u0017\b\u0003'^s!\u0001\u0016,\u000f\u0005q*\u0016\"\u0001\t\n\u0005-y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002[\u0015\u0005Q\u0001+\u0019:b[\u0016$XM]:\n\u0005qk&\u0001E'fe\u001e,G\rU1sC6,G/\u001a:t\u0015\tQ&\"\u0001\beCR\fgI]1nKR{'\u000b\u0012#\u0015\u000b\u0001tw\u000e]9\u0011\u0007\u0005$g-D\u0001c\u0015\t\u0019W&A\u0002sI\u0012L!!\u001a2\u0003\u0007I#E\t\u0005\u0002hW:\u0011\u0001.\u001b\t\u0003yQI!A\u001b\u000b\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003URAQ\u0001\u000b\u0003A\u0002%BQ!\u000e\u0003A\u0002YBQA\u0014\u0003A\u0002=CQA\u001d\u0003A\u0002M\faAZ8s[\u0006$\bC\u0001;|\u001d\t)\bP\u0004\u0002Rm&\u0011qOC\u0001\u0003S>L!!\u001f>\u0002\u001fM+\b\u000f]8si\u0016$gi\u001c:nCRT!a\u001e\u0006\n\u0005ql(aD*vaB|'\u000f^3e\r>\u0014X.\u0019;\u000b\u0005eT\u0018\u0001\u00069sKB\f'/Z*dQ\u0016l\u0017MR8s\u0015N|g\u000e\u0006\u0003\u0002\u0002\u00055\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d1&A\u0003usB,7/\u0003\u0003\u0002\f\u0005\u0015!AC*ueV\u001cG\u000fV=qK\"9\u0011qB\u0003A\u0002\u0005\u0005\u0011AB:dQ\u0016l\u0017-A\u000fhK:\u001cuN\u001c<feNLwN\u001c$v]\u000e$\u0018n\u001c8t\r>\u0014(j]8o)\u0019\t)\"a\n\u0002*A)1#a\u0006\u0002\u001c%\u0019\u0011\u0011\u0004\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u000fM\ti\"!\t\u0002\"%\u0019\u0011q\u0004\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\n\u0002$%\u0019\u0011Q\u0005\u000b\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0010\u0019\u0001\r!!\u0001\t\u000b93\u0001\u0019A(\u0002)I,Wn\u001c<f+N,G.Z:t\u0007>dW/\u001c8t)\u00151\u0014qFA\u001a\u0011\u0019\t\td\u0002a\u0001m\u0005IA-\u0019;b\rJ\fW.\u001a\u0005\u0006\u001d\u001e\u0001\raT\u0001\u0017O\u0016t7i\u001c8wKJ\u001c\u0018n\u001c8Gk:\u001cG/[8ogR1\u0011QCA\u001d\u0003wAq!a\u0004\t\u0001\u0004\t\t\u0001C\u0003O\u0011\u0001\u0007q\n")
public class SnowflakeWriter {
    private final JDBCWrapper jdbcWrapper;

    public void save(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        Enumeration.Value format;
        Enumeration.Value value = format = Utils$.MODULE$.containVariant(data.schema()) ? SupportedFormat$.MODULE$.JSON() : SupportedFormat$.MODULE$.CSV();
        if (params.columnMap().isEmpty()) {
            String string = params.columnMapping();
            String string2 = "name";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (ServerConnection conn = this.jdbcWrapper.getConnector(params);){
                    Some toSchema = new Some((Object)Utils$.MODULE$.removeQuote(this.jdbcWrapper.resolveTable(conn, ((TableName)params.table().get()).name(), params)));
                    params.setColumnMap((Option<StructType>)Option$.MODULE$.apply((Object)data.schema()), (Option<StructType>)toSchema);
                }
            }
        }
        Dataset<Row> output = this.removeUselessColumns(data, params);
        RDD<String> strRDD = this.dataFrameToRDD(sqlContext, output, params, format);
        package$.MODULE$.writeRDD(sqlContext, params, strRDD, output.schema(), saveMode, format, package$.MODULE$.writeRDD$default$7());
    }

    public RDD<String> dataFrameToRDD(SQLContext sqlContext, Dataset<Row> data, Parameters.MergedParameters params, Enumeration.Value format) {
        SparkSession spark = sqlContext.sparkSession();
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Function1<Object, Object>[] conversionFunction = this.genConversionFunctions(data.schema(), params);
            return data.rdd().map((Function1 & Serializable)row -> ((IterableOnceOps)((IterableOps)row.toSeq().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])conversionFunction))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object element = tuple2._1();
                    Function1 func = (Function1)tuple2._2();
                    return func.apply(element);
                }
                throw new MatchError((Object)tuple2);
            })).mkString("|"), ClassTag$.MODULE$.apply(String.class));
        }
        Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StructType newSchema = this.prepareSchemaForJson(data.schema());
            Function1<Object, Object>[] conversionsFunction = this.genConversionFunctionsForJson(data.schema(), params);
            RDD newData = data.rdd().map((Function1 & Serializable)row -> Row$.MODULE$.fromSeq((Seq)((IterableOps)row.toSeq().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])conversionsFunction))).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Object element = tuple2._1();
                    Function1 func = (Function1)tuple2._2();
                    return func.apply(element);
                }
                throw new MatchError((Object)tuple2);
            })), ClassTag$.MODULE$.apply(Row.class));
            return spark.createDataFrame(newData, newSchema).toJSON().map((Function1 & Serializable)x$1 -> x$1.toString(), spark.implicits().newStringEncoder()).rdd();
        }
        throw new MatchError((Object)value);
    }

    private StructType prepareSchemaForJson(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                StructField structField2 = structField;
                DataType dataType = structField2.dataType();
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                    return new StructField(structField2.name(), (DataType)StringType$.MODULE$, structField2.nullable(), structField2.metadata());
                }
            }
            return structField;
        }));
    }

    private Function1<Object, Object>[] genConversionFunctionsForJson(StructType schema, Parameters.MergedParameters params) {
        return (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            DataType dataType = field.dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)v -> {
                    if (params.trimSpace()) {
                        return v.toString().trim();
                    }
                    return v;
                };
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)v -> {
                    Object object = v;
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof byte[]) {
                        byte[] byArray = (byte[])object;
                        return Base64.encodeBase64String((byte[])byArray);
                    }
                    throw new MatchError(object);
                };
            }
            return (Function1 & Serializable)input -> input;
        }, ClassTag$.MODULE$.apply(Function1.class));
    }

    private Dataset<Row> removeUselessColumns(Dataset<Row> dataFrame, Parameters.MergedParameters params) {
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Dataset dataset;
            Some some = (Some)option;
            Map map = (Map)some.value();
            Seq names = (Seq)map.keys().toSeq().map((Function1 & Serializable)name -> {
                if (name.contains(".")) {
                    return new StringBuilder(2).append("`").append((String)name).append("`").toString();
                }
                return name;
            });
            try {
                dataset = dataFrame.select((String)names.head(), (Seq)names.tail());
            }
            catch (AnalysisException e) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Incorrect column name when column mapping: ").append(e.toString()).toString());
            }
            return dataset;
        }
        return dataFrame;
    }

    public Function1<Object, Object>[] genConversionFunctions(StructType schema, Parameters.MergedParameters params) {
        return (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            DataType dataType = field.dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)v -> {
                    Object object = v;
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)object;
                        return Conversions$.MODULE$.formatTimestamp(timestamp);
                    }
                    if (object instanceof Date) {
                        Date date = (Date)object;
                        return Conversions$.MODULE$.formatDate(date);
                    }
                    throw new MatchError(object);
                };
            }
            if (TimestampType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)v -> {
                    if (v == null) {
                        return "";
                    }
                    return Conversions$.MODULE$.formatTimestamp((Timestamp)v);
                };
            }
            if (StringType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)v -> {
                    if (v == null) {
                        return "";
                    }
                    Object trimmed = params.trimSpace() ? v.toString().trim() : v;
                    return Conversions$.MODULE$.formatString((String)trimmed);
                };
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return (Function1 & Serializable)v -> {
                    Object object = v;
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof byte[]) {
                        byte[] byArray = (byte[])object;
                        return Base64.encodeBase64String((byte[])byArray);
                    }
                    throw new MatchError(object);
                };
            }
            return (Function1 & Serializable)v -> Conversions$.MODULE$.formatAny(v);
        }, ClassTag$.MODULE$.apply(Function1.class));
    }

    public SnowflakeWriter(JDBCWrapper jdbcWrapper) {
        this.jdbcWrapper = jdbcWrapper;
    }
}

