/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.converter.BatikDetector;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.converter.FreeHepDetector;
import net.sourceforge.jeuclid.converter.ImageIODetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConverterRegistry {
    private final Map<String, ConverterPlugin> mimetype2converter = new HashMap<String, ConverterPlugin>();
    private final Map<String, String> mimetype2suffix = new HashMap<String, String>();
    private final Map<String, String> suffix2mimetype = new HashMap<String, String>();

    protected ConverterRegistry() {
        ImageIODetector.detectConversionPlugins(this);
        BatikDetector.detectConversionPlugins(this);
        FreeHepDetector.detectConversionPlugins(this);
    }

    public static ConverterRegistry getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static ConverterRegistry getRegisty() {
        return ConverterRegistry.getInstance();
    }

    public Set<String> getAvailableOutfileTypes() {
        return this.mimetype2converter.keySet();
    }

    public Set<String> getAvailableExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.suffix2mimetype.entrySet()) {
            if (!this.mimetype2converter.containsKey(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public String getSuffixForMimeType(String string) {
        return this.mimetype2suffix.get(string.toLowerCase(Locale.ENGLISH));
    }

    public String getMimeTypeForSuffix(String string) {
        return this.suffix2mimetype.get(string.toLowerCase(Locale.ENGLISH));
    }

    public void registerMimeTypeAndSuffix(String string, String string2, boolean bl) {
        String string3 = string.toLowerCase(Locale.ENGLISH);
        String string4 = string2.toLowerCase(Locale.ENGLISH);
        if (bl || !this.suffix2mimetype.containsKey(string4)) {
            this.suffix2mimetype.put(string4, string3);
        }
        if (bl || !this.mimetype2suffix.containsKey(string3)) {
            this.mimetype2suffix.put(string3, string4);
        }
    }

    public void registerConverter(String string, ConverterPlugin converterPlugin, boolean bl) {
        if (bl || !this.mimetype2converter.containsKey(string)) {
            this.mimetype2converter.put(string, converterPlugin);
        }
    }

    public ConverterPlugin getConverter(String string) {
        return this.mimetype2converter.get(string.toLowerCase(Locale.ENGLISH));
    }

    private static final class SingletonHolder {
        private static final ConverterRegistry INSTANCE = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

