/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Hyperlink;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.CellReferenceHelper;
import jxl.biff.ConditionalFormat;
import jxl.biff.DataValidation;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkbookMethods;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Button;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.CheckBox;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.common.Assert;
import jxl.common.Logger;
import jxl.format.CellFormat;
import jxl.read.biff.NameRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.WorkbookParser;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadDateFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WritableWorkbookImpl;

class SheetCopier {
    private static Logger logger = Logger.getLogger(SheetCopier.class);
    private SheetImpl fromSheet;
    private WritableSheetImpl toSheet;
    private WorkbookSettings workbookSettings;
    private TreeSet columnFormats;
    private FormattingRecords formatRecords;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private ArrayList rowBreaks;
    private ArrayList columnBreaks;
    private SheetWriter sheetWriter;
    private ArrayList drawings;
    private ArrayList images;
    private ArrayList conditionalFormats;
    private ArrayList validatedCells;
    private AutoFilter autoFilter;
    private DataValidation dataValidation;
    private ComboBox comboBox;
    private PLSRecord plsRecord;
    private boolean chartOnly;
    private ButtonPropertySetRecord buttonPropertySet;
    private int numRows;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private HashMap xfRecords;
    private HashMap fonts;
    private HashMap formats;

    public SheetCopier(Sheet f, WritableSheet t) {
        this.fromSheet = (SheetImpl)f;
        this.toSheet = (WritableSheetImpl)t;
        this.workbookSettings = this.toSheet.getWorkbook().getSettings();
        this.chartOnly = false;
    }

    void setColumnFormats(TreeSet cf) {
        this.columnFormats = cf;
    }

    void setFormatRecords(FormattingRecords fr) {
        this.formatRecords = fr;
    }

    void setHyperlinks(ArrayList h) {
        this.hyperlinks = h;
    }

    void setMergedCells(MergedCells mc) {
        this.mergedCells = mc;
    }

    void setRowBreaks(ArrayList rb) {
        this.rowBreaks = rb;
    }

    void setColumnBreaks(ArrayList cb) {
        this.columnBreaks = cb;
    }

    void setSheetWriter(SheetWriter sw) {
        this.sheetWriter = sw;
    }

    void setDrawings(ArrayList d) {
        this.drawings = d;
    }

    void setImages(ArrayList i) {
        this.images = i;
    }

    void setConditionalFormats(ArrayList cf) {
        this.conditionalFormats = cf;
    }

    void setValidatedCells(ArrayList vc) {
        this.validatedCells = vc;
    }

    AutoFilter getAutoFilter() {
        return this.autoFilter;
    }

    DataValidation getDataValidation() {
        return this.dataValidation;
    }

    ComboBox getComboBox() {
        return this.comboBox;
    }

    PLSRecord getPLSRecord() {
        return this.plsRecord;
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    public void copySheet() {
        ConditionalFormat[] cf;
        int[] columnbreaks;
        this.shallowCopyCells();
        jxl.read.biff.ColumnInfoRecord[] readCirs = this.fromSheet.getColumnInfos();
        for (int i = 0; i < readCirs.length; ++i) {
            jxl.read.biff.ColumnInfoRecord rcir = readCirs[i];
            for (int j = rcir.getStartColumn(); j <= rcir.getEndColumn(); ++j) {
                ColumnInfoRecord cir = new ColumnInfoRecord(rcir, j, this.formatRecords);
                cir.setHidden(rcir.getHidden());
                this.columnFormats.add(cir);
            }
        }
        Hyperlink[] hls = this.fromSheet.getHyperlinks();
        for (int i = 0; i < hls.length; ++i) {
            WritableHyperlink hr = new WritableHyperlink(hls[i], this.toSheet);
            this.hyperlinks.add(hr);
        }
        Range[] merged = this.fromSheet.getMergedCells();
        for (int i = 0; i < merged.length; ++i) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i], this.toSheet));
        }
        try {
            jxl.read.biff.RowRecord[] rowprops = this.fromSheet.getRowProperties();
            for (int i = 0; i < rowprops.length; ++i) {
                RowRecord rr = this.toSheet.getRowRecord(rowprops[i].getRowNumber());
                XFRecord format = rowprops[i].hasDefaultFormat() ? this.formatRecords.getXFRecord(rowprops[i].getXFIndex()) : null;
                rr.setRowDetails(rowprops[i].getRowHeight(), rowprops[i].matchesDefaultFontHeight(), rowprops[i].isCollapsed(), rowprops[i].getOutlineLevel(), rowprops[i].getGroupStart(), format);
                this.numRows = Math.max(this.numRows, rowprops[i].getRowNumber() + 1);
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        int[] rowbreaks = this.fromSheet.getRowPageBreaks();
        if (rowbreaks != null) {
            for (int i = 0; i < rowbreaks.length; ++i) {
                this.rowBreaks.add(new Integer(rowbreaks[i]));
            }
        }
        if ((columnbreaks = this.fromSheet.getColumnPageBreaks()) != null) {
            for (int i = 0; i < columnbreaks.length; ++i) {
                this.columnBreaks.add(new Integer(columnbreaks[i]));
            }
        }
        this.sheetWriter.setCharts(this.fromSheet.getCharts());
        DrawingGroupObject[] dr = this.fromSheet.getDrawings();
        for (int i = 0; i < dr.length; ++i) {
            DrawingGroupObject cb;
            if (dr[i] instanceof Drawing) {
                WritableImage wi = new WritableImage(dr[i], this.toSheet.getWorkbook().getDrawingGroup());
                this.drawings.add(wi);
                this.images.add(wi);
                continue;
            }
            if (dr[i] instanceof Comment) {
                Comment c = new Comment(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(c);
                CellValue cv = (CellValue)this.toSheet.getWritableCell(c.getColumn(), c.getRow());
                Assert.verify(cv.getCellFeatures() != null);
                cv.getWritableCellFeatures().setCommentDrawing(c);
                continue;
            }
            if (dr[i] instanceof Button) {
                Button b = new Button(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(b);
                continue;
            }
            if (dr[i] instanceof ComboBox) {
                cb = new ComboBox(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(cb);
                continue;
            }
            if (!(dr[i] instanceof CheckBox)) continue;
            cb = new CheckBox(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
            this.drawings.add(cb);
        }
        DataValidation rdv = this.fromSheet.getDataValidation();
        if (rdv != null) {
            this.dataValidation = new DataValidation(rdv, (ExternalSheet)this.toSheet.getWorkbook(), (WorkbookMethods)this.toSheet.getWorkbook(), this.workbookSettings);
            int objid = this.dataValidation.getComboBoxObjectId();
            if (objid != 0) {
                this.comboBox = (ComboBox)this.drawings.get(objid);
            }
        }
        if ((cf = this.fromSheet.getConditionalFormats()).length > 0) {
            for (int i = 0; i < cf.length; ++i) {
                this.conditionalFormats.add(cf[i]);
            }
        }
        this.autoFilter = this.fromSheet.getAutoFilter();
        this.sheetWriter.setWorkspaceOptions(this.fromSheet.getWorkspaceOptions());
        if (this.fromSheet.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (this.fromSheet.getPLS() != null) {
            if (this.fromSheet.getWorkbookBof().isBiff7()) {
                logger.warn("Cannot copy Biff7 print settings record - ignoring");
            } else {
                this.plsRecord = new PLSRecord(this.fromSheet.getPLS());
            }
        }
        if (this.fromSheet.getButtonPropertySet() != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(this.fromSheet.getButtonPropertySet());
        }
        this.maxRowOutlineLevel = this.fromSheet.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = this.fromSheet.getMaxColumnOutlineLevel();
    }

    public void copyWritableSheet() {
        this.shallowCopyCells();
    }

    public void importSheet() {
        DrawingGroupObject[] dr;
        Chart[] fromCharts;
        int[] columnbreaks;
        this.xfRecords = new HashMap();
        this.fonts = new HashMap();
        this.formats = new HashMap();
        this.deepCopyCells();
        jxl.read.biff.ColumnInfoRecord[] readCirs = this.fromSheet.getColumnInfos();
        for (int i = 0; i < readCirs.length; ++i) {
            jxl.read.biff.ColumnInfoRecord rcir = readCirs[i];
            for (int j = rcir.getStartColumn(); j <= rcir.getEndColumn(); ++j) {
                ColumnInfoRecord cir = new ColumnInfoRecord(rcir, j);
                int xfIndex = cir.getXfIndex();
                WritableCellFormat cf = (WritableCellFormat)this.xfRecords.get(new Integer(xfIndex));
                if (cf == null) {
                    CellFormat readFormat = this.fromSheet.getColumnView(j).getFormat();
                    WritableCellFormat wcf = this.copyCellFormat(readFormat);
                }
                cir.setCellFormat(cf);
                cir.setHidden(rcir.getHidden());
                this.columnFormats.add(cir);
            }
        }
        Hyperlink[] hls = this.fromSheet.getHyperlinks();
        for (int i = 0; i < hls.length; ++i) {
            WritableHyperlink hr = new WritableHyperlink(hls[i], this.toSheet);
            this.hyperlinks.add(hr);
        }
        Range[] merged = this.fromSheet.getMergedCells();
        for (int i = 0; i < merged.length; ++i) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i], this.toSheet));
        }
        try {
            jxl.read.biff.RowRecord[] rowprops = this.fromSheet.getRowProperties();
            for (int i = 0; i < rowprops.length; ++i) {
                RowRecord rr = this.toSheet.getRowRecord(rowprops[i].getRowNumber());
                WritableCellFormat format = null;
                jxl.read.biff.RowRecord rowrec = rowprops[i];
                if (rowrec.hasDefaultFormat() && (format = (WritableCellFormat)this.xfRecords.get(new Integer(rowrec.getXFIndex()))) == null) {
                    int rownum = rowrec.getRowNumber();
                    CellFormat readFormat = this.fromSheet.getRowView(rownum).getFormat();
                    WritableCellFormat wcf = this.copyCellFormat(readFormat);
                }
                rr.setRowDetails(rowrec.getRowHeight(), rowrec.matchesDefaultFontHeight(), rowrec.isCollapsed(), rowrec.getOutlineLevel(), rowrec.getGroupStart(), format);
                this.numRows = Math.max(this.numRows, rowprops[i].getRowNumber() + 1);
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        int[] rowbreaks = this.fromSheet.getRowPageBreaks();
        if (rowbreaks != null) {
            for (int i = 0; i < rowbreaks.length; ++i) {
                this.rowBreaks.add(new Integer(rowbreaks[i]));
            }
        }
        if ((columnbreaks = this.fromSheet.getColumnPageBreaks()) != null) {
            for (int i = 0; i < columnbreaks.length; ++i) {
                this.columnBreaks.add(new Integer(columnbreaks[i]));
            }
        }
        if ((fromCharts = this.fromSheet.getCharts()) != null && fromCharts.length > 0) {
            logger.warn("Importing of charts is not supported");
        }
        if ((dr = this.fromSheet.getDrawings()).length > 0 && this.toSheet.getWorkbook().getDrawingGroup() == null) {
            this.toSheet.getWorkbook().createDrawingGroup();
        }
        for (int i = 0; i < dr.length; ++i) {
            if (dr[i] instanceof Drawing) {
                WritableImage wi = new WritableImage(dr[i].getX(), dr[i].getY(), dr[i].getWidth(), dr[i].getHeight(), dr[i].getImageData());
                this.toSheet.getWorkbook().addDrawing(wi);
                this.drawings.add(wi);
                this.images.add(wi);
                continue;
            }
            if (dr[i] instanceof Comment) {
                Comment c = new Comment(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(c);
                CellValue cv = (CellValue)this.toSheet.getWritableCell(c.getColumn(), c.getRow());
                Assert.verify(cv.getCellFeatures() != null);
                cv.getWritableCellFeatures().setCommentDrawing(c);
                continue;
            }
            if (dr[i] instanceof Button) {
                Button b = new Button(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
                this.drawings.add(b);
                continue;
            }
            if (!(dr[i] instanceof ComboBox)) continue;
            ComboBox cb = new ComboBox(dr[i], this.toSheet.getWorkbook().getDrawingGroup(), this.workbookSettings);
            this.drawings.add(cb);
        }
        DataValidation rdv = this.fromSheet.getDataValidation();
        if (rdv != null) {
            this.dataValidation = new DataValidation(rdv, (ExternalSheet)this.toSheet.getWorkbook(), (WorkbookMethods)this.toSheet.getWorkbook(), this.workbookSettings);
            int objid = this.dataValidation.getComboBoxObjectId();
            if (objid != 0) {
                this.comboBox = (ComboBox)this.drawings.get(objid);
            }
        }
        this.sheetWriter.setWorkspaceOptions(this.fromSheet.getWorkspaceOptions());
        if (this.fromSheet.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (this.fromSheet.getPLS() != null) {
            if (this.fromSheet.getWorkbookBof().isBiff7()) {
                logger.warn("Cannot copy Biff7 print settings record - ignoring");
            } else {
                this.plsRecord = new PLSRecord(this.fromSheet.getPLS());
            }
        }
        if (this.fromSheet.getButtonPropertySet() != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(this.fromSheet.getButtonPropertySet());
        }
        this.importNames();
        this.maxRowOutlineLevel = this.fromSheet.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = this.fromSheet.getMaxColumnOutlineLevel();
    }

    private WritableCell shallowCopyCell(Cell cell) {
        CellType ct = cell.getType();
        CellValue newCell = null;
        if (ct == CellType.LABEL) {
            newCell = new Label((LabelCell)cell);
        } else if (ct == CellType.NUMBER) {
            newCell = new Number((NumberCell)cell);
        } else if (ct == CellType.DATE) {
            newCell = new DateTime((DateCell)cell);
        } else if (ct == CellType.BOOLEAN) {
            newCell = new Boolean((BooleanCell)cell);
        } else if (ct == CellType.NUMBER_FORMULA) {
            newCell = new ReadNumberFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.STRING_FORMULA) {
            newCell = new ReadStringFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.BOOLEAN_FORMULA) {
            newCell = new ReadBooleanFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.DATE_FORMULA) {
            newCell = new ReadDateFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.FORMULA_ERROR) {
            newCell = new ReadErrorFormulaRecord((FormulaData)cell);
        } else if (ct == CellType.EMPTY && cell.getCellFormat() != null) {
            newCell = new Blank(cell);
        }
        return newCell;
    }

    private WritableCell deepCopyCell(Cell cell) {
        CellFormat cf;
        int index;
        WritableCellFormat wcf;
        WritableCell c = this.shallowCopyCell(cell);
        if (c == null) {
            return c;
        }
        if (c instanceof ReadFormulaRecord) {
            boolean crossSheetReference;
            ReadFormulaRecord rfr = (ReadFormulaRecord)c;
            boolean bl = crossSheetReference = !rfr.handleImportedCellReferences(this.fromSheet.getWorkbook(), this.fromSheet.getWorkbook(), this.workbookSettings);
            if (crossSheetReference) {
                try {
                    logger.warn("Formula " + rfr.getFormula() + " in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported because it references another " + " sheet from the source workbook");
                }
                catch (FormulaException e) {
                    logger.warn("Formula  in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported:  " + e.getMessage());
                }
                c = new Formula(cell.getColumn(), cell.getRow(), "\"ERROR\"");
            }
        }
        if ((wcf = (WritableCellFormat)this.xfRecords.get(new Integer(index = ((XFRecord)(cf = c.getCellFormat())).getXFIndex()))) == null) {
            wcf = this.copyCellFormat(cf);
        }
        c.setCellFormat(wcf);
        return c;
    }

    void shallowCopyCells() {
        int cells = this.fromSheet.getRows();
        Cell[] row = null;
        Cell cell = null;
        for (int i = 0; i < cells; ++i) {
            row = this.fromSheet.getRow(i);
            for (int j = 0; j < row.length; ++j) {
                cell = row[j];
                WritableCell c = this.shallowCopyCell(cell);
                try {
                    if (c == null) continue;
                    this.toSheet.addCell(c);
                    if (c.getCellFeatures() == null || !c.getCellFeatures().hasDataValidation()) continue;
                    this.validatedCells.add(c);
                    continue;
                }
                catch (WriteException e) {
                    Assert.verify(false);
                }
            }
        }
        this.numRows = this.toSheet.getRows();
    }

    void deepCopyCells() {
        int cells = this.fromSheet.getRows();
        Cell[] row = null;
        Cell cell = null;
        for (int i = 0; i < cells; ++i) {
            row = this.fromSheet.getRow(i);
            for (int j = 0; j < row.length; ++j) {
                cell = row[j];
                WritableCell c = this.deepCopyCell(cell);
                try {
                    if (c == null) continue;
                    this.toSheet.addCell(c);
                    if (!(c.getCellFeatures() != null & c.getCellFeatures().hasDataValidation())) continue;
                    this.validatedCells.add(c);
                    continue;
                }
                catch (WriteException e) {
                    Assert.verify(false);
                }
            }
        }
    }

    private WritableCellFormat copyCellFormat(CellFormat cf) {
        try {
            XFRecord xfr = (XFRecord)cf;
            WritableCellFormat f = new WritableCellFormat((CellFormat)xfr);
            this.formatRecords.addStyle(f);
            int xfIndex = xfr.getXFIndex();
            this.xfRecords.put(new Integer(xfIndex), f);
            int fontIndex = xfr.getFontIndex();
            this.fonts.put(new Integer(fontIndex), new Integer(f.getFontIndex()));
            int formatIndex = xfr.getFormatRecord();
            this.formats.put(new Integer(formatIndex), new Integer(f.getFormatRecord()));
            return f;
        }
        catch (NumFormatRecordsException e) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            return WritableWorkbook.NORMAL_STYLE;
        }
    }

    private void importNames() {
        WorkbookParser fromWorkbook = this.fromSheet.getWorkbook();
        WritableWorkbookImpl toWorkbook = this.toSheet.getWorkbook();
        int fromSheetIndex = fromWorkbook.getIndex(this.fromSheet);
        NameRecord[] nameRecords = fromWorkbook.getNameRecords();
        Object[] names = ((WritableWorkbook)toWorkbook).getRangeNames();
        for (int i = 0; i < nameRecords.length; ++i) {
            NameRecord.NameRange[] nameRanges = nameRecords[i].getRanges();
            for (int j = 0; j < nameRanges.length; ++j) {
                int nameSheetIndex = fromWorkbook.getExternalSheetIndex(nameRanges[j].getExternalSheet());
                if (fromSheetIndex != nameSheetIndex) continue;
                String name = nameRecords[i].getName();
                if (Arrays.binarySearch(names, name) < 0) {
                    ((WritableWorkbook)toWorkbook).addNameArea(name, this.toSheet, nameRanges[j].getFirstColumn(), nameRanges[j].getFirstRow(), nameRanges[j].getLastColumn(), nameRanges[j].getLastRow());
                    continue;
                }
                logger.warn("Named range " + name + " is already present in the destination workbook");
            }
        }
    }

    int getRows() {
        return this.numRows;
    }

    public int getMaxColumnOutlineLevel() {
        return this.maxColumnOutlineLevel;
    }

    public int getMaxRowOutlineLevel() {
        return this.maxRowOutlineLevel;
    }
}

