/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractPropertySource;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.ImmutableLanguage;

public abstract class AbstractRule
extends AbstractPropertySource
implements Rule {
    private Language language;
    private LanguageVersion minimumLanguageVersion;
    private LanguageVersion maximumLanguageVersion;
    private boolean deprecated;
    private String name = this.getClass().getName();
    private String since;
    private String ruleClass = this.getClass().getName();
    private String ruleSetName;
    private String message;
    private String description;
    private List<String> examples = new ArrayList<String>();
    private String externalInfoUrl;
    private RulePriority priority = RulePriority.LOW;
    private boolean usesDFA;
    private boolean usesTypeResolution;
    private List<String> ruleChainVisits = new ArrayList<String>();

    public AbstractRule() {
        this.definePropertyDescriptor(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
        this.definePropertyDescriptor(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR);
    }

    public void deepCopyValuesTo(AbstractRule otherRule) {
        otherRule.language = this.language;
        otherRule.minimumLanguageVersion = this.minimumLanguageVersion;
        otherRule.maximumLanguageVersion = this.maximumLanguageVersion;
        otherRule.deprecated = this.deprecated;
        otherRule.name = this.name;
        otherRule.since = this.since;
        otherRule.ruleClass = this.ruleClass;
        otherRule.ruleSetName = this.ruleSetName;
        otherRule.message = this.message;
        otherRule.description = this.description;
        otherRule.examples = this.copyExamples();
        otherRule.externalInfoUrl = this.externalInfoUrl;
        otherRule.priority = this.priority;
        otherRule.propertyDescriptors = this.copyPropertyDescriptors();
        otherRule.propertyValuesByDescriptor = this.copyPropertyValues();
        otherRule.usesDFA = this.usesDFA;
        otherRule.usesTypeResolution = this.usesTypeResolution;
        otherRule.ruleChainVisits = this.copyRuleChainVisits();
    }

    private List<String> copyExamples() {
        ArrayList<String> copy = new ArrayList<String>(this.examples.size());
        copy.addAll(this.examples);
        return copy;
    }

    private List<String> copyRuleChainVisits() {
        ArrayList<String> copy = new ArrayList<String>(this.ruleChainVisits.size());
        copy.addAll(this.ruleChainVisits);
        return copy;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(Language language) {
        if (this.language != null && this instanceof ImmutableLanguage && !this.language.equals(language)) {
            throw new UnsupportedOperationException("The Language for Rule class " + this.getClass().getName() + " is immutable and cannot be changed.");
        }
        this.language = language;
    }

    @Override
    public LanguageVersion getMinimumLanguageVersion() {
        return this.minimumLanguageVersion;
    }

    @Override
    public void setMinimumLanguageVersion(LanguageVersion minimumLanguageVersion) {
        this.minimumLanguageVersion = minimumLanguageVersion;
    }

    @Override
    public LanguageVersion getMaximumLanguageVersion() {
        return this.maximumLanguageVersion;
    }

    @Override
    public void setMaximumLanguageVersion(LanguageVersion maximumLanguageVersion) {
        this.maximumLanguageVersion = maximumLanguageVersion;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public void setSince(String since) {
        this.since = since;
    }

    @Override
    public String getRuleClass() {
        return this.ruleClass;
    }

    @Override
    public void setRuleClass(String ruleClass) {
        this.ruleClass = ruleClass;
    }

    @Override
    public String getRuleSetName() {
        return this.ruleSetName;
    }

    @Override
    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public void addExample(String example) {
        this.examples.add(example);
    }

    @Override
    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String externalInfoUrl) {
        this.externalInfoUrl = externalInfoUrl;
    }

    @Override
    public RulePriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(RulePriority priority) {
        this.priority = priority;
    }

    @Override
    public ParserOptions getParserOptions() {
        return new ParserOptions();
    }

    @Override
    public void setUsesDFA() {
        this.usesDFA = true;
    }

    @Override
    public boolean usesDFA() {
        return this.usesDFA;
    }

    @Override
    public void setUsesTypeResolution() {
        this.usesTypeResolution = true;
    }

    @Override
    public boolean usesTypeResolution() {
        return this.usesTypeResolution;
    }

    @Override
    public boolean usesRuleChain() {
        return !this.getRuleChainVisits().isEmpty();
    }

    @Override
    public List<String> getRuleChainVisits() {
        return this.ruleChainVisits;
    }

    @Override
    public void addRuleChainVisit(Class<? extends Node> nodeClass) {
        if (!nodeClass.getSimpleName().startsWith("AST")) {
            throw new IllegalArgumentException("Node class does not start with 'AST' prefix: " + nodeClass);
        }
        this.addRuleChainVisit(nodeClass.getSimpleName().substring("AST".length()));
    }

    @Override
    public void addRuleChainVisit(String astNodeName) {
        if (!this.ruleChainVisits.contains(astNodeName)) {
            this.ruleChainVisits.add(astNodeName);
        }
    }

    @Override
    public void start(RuleContext ctx) {
    }

    @Override
    public void end(RuleContext ctx) {
    }

    public void addViolation(Object data, Node node) {
        RuleContext ruleContext = (RuleContext)data;
        ruleContext.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory().addViolation(ruleContext, this, node, this.getMessage(), null);
    }

    public void addViolation(Object data, Node node, String arg) {
        RuleContext ruleContext = (RuleContext)data;
        ruleContext.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory().addViolation(ruleContext, this, node, this.getMessage(), new Object[]{arg});
    }

    public void addViolation(Object data, Node node, Object[] args) {
        RuleContext ruleContext = (RuleContext)data;
        ruleContext.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory().addViolation(ruleContext, this, node, this.getMessage(), args);
    }

    public void addViolationWithMessage(Object data, Node node, String message) {
        RuleContext ruleContext = (RuleContext)data;
        ruleContext.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory().addViolation(ruleContext, this, node, message, null);
    }

    public void addViolationWithMessage(Object data, Node node, String message, int beginLine, int endLine) {
        RuleContext ruleContext = (RuleContext)data;
        ruleContext.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory().addViolation(ruleContext, this, node, message, beginLine, endLine, null);
    }

    public void addViolationWithMessage(Object data, Node node, String message, Object[] args) {
        RuleContext ruleContext = (RuleContext)data;
        ruleContext.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory().addViolation(ruleContext, this, node, message, args);
    }

    public boolean equals(Object o) {
        boolean equality;
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        boolean bl = equality = this.getClass() == o.getClass();
        if (equality) {
            Rule that = (Rule)o;
            equality = this.getName().equals(that.getName()) && this.getPriority().equals((Object)that.getPriority()) && this.getPropertiesByPropertyDescriptor().equals(that.getPropertiesByPropertyDescriptor());
        }
        return equality;
    }

    public int hashCode() {
        Map<PropertyDescriptor<?>, Object> propertyValues = this.getPropertiesByPropertyDescriptor();
        return this.getClass().getName().hashCode() + (this.getName() != null ? this.getName().hashCode() : 0) + this.getPriority().hashCode() + (propertyValues != null ? ((Object)propertyValues).hashCode() : 0);
    }
}

