/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactoryCompatibility;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.factories.PropertyDescriptorUtil;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.pmd.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RuleSetFactory {
    private static final Logger LOG = Logger.getLogger(RuleSetFactory.class.getName());
    private static final String DESCRIPTION = "description";
    private static final String UNEXPECTED_ELEMENT = "Unexpected element <";
    private static final String PRIORITY = "priority";
    private static final String FOR_RULE = "' for Rule ";
    private static final String MESSAGE = "message";
    private static final String EXTERNAL_INFO_URL = "externalInfoUrl";
    private final ClassLoader classLoader;
    private final RulePriority minimumPriority;
    private final boolean warnDeprecated;
    private final RuleSetFactoryCompatibility compatibilityFilter;

    public RuleSetFactory() {
        this(RuleSetFactory.class.getClassLoader(), RulePriority.LOW, false, true);
    }

    public RuleSetFactory(ClassLoader classLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        this.classLoader = classLoader;
        this.minimumPriority = minimumPriority;
        this.warnDeprecated = warnDeprecated;
        this.compatibilityFilter = enableCompatibility ? new RuleSetFactoryCompatibility() : null;
    }

    public RuleSetFactory(RuleSetFactory factory, boolean warnDeprecated) {
        this(factory.classLoader, factory.minimumPriority, warnDeprecated, factory.compatibilityFilter != null);
    }

    RuleSetFactoryCompatibility getCompatibilityFilter() {
        return this.compatibilityFilter;
    }

    public Iterator<RuleSet> getRegisteredRuleSets() throws RuleSetNotFoundException {
        String rulesetsProperties = null;
        try {
            ArrayList<RuleSetReferenceId> ruleSetReferenceIds = new ArrayList<RuleSetReferenceId>();
            for (Language language : LanguageRegistry.findWithRuleSupport()) {
                Properties props = new Properties();
                rulesetsProperties = "rulesets/" + language.getTerseName() + "/rulesets.properties";
                try (InputStream inputStream = ResourceLoader.loadResourceAsStream(rulesetsProperties);){
                    props.load(inputStream);
                }
                String rulesetFilenames = props.getProperty("rulesets.filenames");
                ruleSetReferenceIds.addAll(RuleSetReferenceId.parse(rulesetFilenames));
            }
            return this.createRuleSets(ruleSetReferenceIds).getRuleSetsIterator();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't find " + rulesetsProperties + "; please ensure that the rulesets directory is on the classpath.  The current classpath is: " + System.getProperty("java.class.path"));
        }
    }

    public RuleSets createRuleSets(String referenceString) throws RuleSetNotFoundException {
        return this.createRuleSets(RuleSetReferenceId.parse(referenceString));
    }

    public RuleSets createRuleSets(List<RuleSetReferenceId> ruleSetReferenceIds) throws RuleSetNotFoundException {
        RuleSets ruleSets = new RuleSets();
        for (RuleSetReferenceId ruleSetReferenceId : ruleSetReferenceIds) {
            RuleSet ruleSet = this.createRuleSet(ruleSetReferenceId);
            ruleSets.addRuleSet(ruleSet);
        }
        return ruleSets;
    }

    public RuleSet createRuleSet(String referenceString) throws RuleSetNotFoundException {
        List<RuleSetReferenceId> references = RuleSetReferenceId.parse(referenceString);
        if (references.isEmpty()) {
            throw new RuleSetNotFoundException("No RuleSetReferenceId can be parsed from the string: <" + referenceString + ">");
        }
        return this.createRuleSet(references.get(0));
    }

    public RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId) throws RuleSetNotFoundException {
        return this.createRuleSet(ruleSetReferenceId, false);
    }

    private RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        return this.parseRuleSetNode(ruleSetReferenceId, withDeprecatedRuleReferences);
    }

    public RuleSet createRuleSetCopy(RuleSet original) {
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(original);
        return builder.build();
    }

    public RuleSet createNewRuleSet(String name, String description, String fileName, Collection<String> excludePatterns, Collection<String> includePatterns, Collection<Rule> rules) {
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(0L);
        builder.withName(name).withDescription(description).withFileName(fileName).setExcludePatterns(excludePatterns).setIncludePatterns(includePatterns);
        for (Rule rule : rules) {
            builder.addRule(rule);
        }
        return builder.build();
    }

    public RuleSet createSingleRuleRuleSet(Rule rule) {
        long checksum = rule instanceof XPathRule ? (long)rule.getProperty(XPathRule.XPATH_DESCRIPTOR).hashCode() : (long)(rule.getPropertiesByPropertyDescriptor().values().hashCode() * 31 + rule.getName().hashCode());
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(checksum);
        builder.addRule(rule);
        return builder.build();
    }

    private Rule createRule(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        if (ruleSetReferenceId.isAllRules()) {
            throw new IllegalArgumentException("Cannot parse a single Rule from an all Rule RuleSet reference: <" + ruleSetReferenceId + ">.");
        }
        RuleSet ruleSet = this.createRuleSet(ruleSetReferenceId, withDeprecatedRuleReferences);
        return ruleSet.getRuleByName(ruleSetReferenceId.getRuleName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RuleSet parseRuleSetNode(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        try (CheckedInputStream inputStream = new CheckedInputStream(ruleSetReferenceId.getInputStream(this.classLoader), new Adler32());){
            if (!ruleSetReferenceId.isExternal()) {
                throw new IllegalArgumentException("Cannot parse a RuleSet from a non-external reference: <" + ruleSetReferenceId + ">.");
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = this.compatibilityFilter != null ? new InputSource(this.compatibilityFilter.filterRuleSetFile(inputStream)) : new InputSource(inputStream);
            Document document = builder.parse(inputSource);
            Element ruleSetElement = document.getDocumentElement();
            RuleSet.RuleSetBuilder ruleSetBuilder = new RuleSet.RuleSetBuilder(inputStream.getChecksum().getValue()).withFileName(ruleSetReferenceId.getRuleSetFileName()).withName(ruleSetElement.getAttribute("name"));
            NodeList nodeList = ruleSetElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if (DESCRIPTION.equals(nodeName)) {
                    ruleSetBuilder.withDescription(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if ("include-pattern".equals(nodeName)) {
                    ruleSetBuilder.addIncludePattern(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if ("exclude-pattern".equals(nodeName)) {
                    ruleSetBuilder.addExcludePattern(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (!"rule".equals(nodeName)) throw new IllegalArgumentException(UNEXPECTED_ELEMENT + node.getNodeName() + "> encountered as child of <ruleset> element.");
                this.parseRuleNode(ruleSetReferenceId, ruleSetBuilder, node, withDeprecatedRuleReferences);
            }
            RuleSet ruleSet = ruleSetBuilder.build();
            return ruleSet;
        }
        catch (ClassNotFoundException cnfe) {
            return RuleSetFactory.classNotFoundProblem(cnfe);
        }
        catch (InstantiationException ie) {
            return RuleSetFactory.classNotFoundProblem(ie);
        }
        catch (IllegalAccessException iae) {
            return RuleSetFactory.classNotFoundProblem(iae);
        }
        catch (ParserConfigurationException pce) {
            return RuleSetFactory.classNotFoundProblem(pce);
        }
        catch (IOException ioe) {
            return RuleSetFactory.classNotFoundProblem(ioe);
        }
        catch (SAXException se) {
            return RuleSetFactory.classNotFoundProblem(se);
        }
    }

    private static RuleSet classNotFoundProblem(Exception ex) {
        ex.printStackTrace();
        throw new RuntimeException("Couldn't find the class " + ex.getMessage());
    }

    private void parseRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode, boolean withDeprecatedRuleReferences) throws ClassNotFoundException, InstantiationException, IllegalAccessException, RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        String ref = ruleElement.getAttribute("ref");
        if (ref.endsWith("xml")) {
            this.parseRuleSetReferenceNode(ruleSetReferenceId, ruleSetBuilder, ruleElement, ref);
        } else if (StringUtil.isEmpty(ref)) {
            this.parseSingleRuleNode(ruleSetReferenceId, ruleSetBuilder, ruleNode);
        } else {
            this.parseRuleReferenceNode(ruleSetReferenceId, ruleSetBuilder, ruleNode, ref, withDeprecatedRuleReferences);
        }
    }

    private void parseRuleSetReferenceNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleElement, String ref) throws RuleSetNotFoundException {
        RuleSetReference ruleSetReference = new RuleSetReference();
        ruleSetReference.setAllRules(true);
        ruleSetReference.setRuleSetFileName(ref);
        String priority = null;
        NodeList childNodes = ruleElement.getChildNodes();
        HashSet<String> excludedRulesCheck = new HashSet<String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (RuleSetFactory.isElementNode(child, "exclude")) {
                Element excludeElement = (Element)child;
                String excludedRuleName = excludeElement.getAttribute("name");
                ruleSetReference.addExclude(excludedRuleName);
                excludedRulesCheck.add(excludedRuleName);
                continue;
            }
            if (!RuleSetFactory.isElementNode(child, PRIORITY)) continue;
            priority = RuleSetFactory.parseTextNode(child).trim();
        }
        RuleSetFactory ruleSetFactory = new RuleSetFactory(this, this.warnDeprecated);
        RuleSet otherRuleSet = ruleSetFactory.createRuleSet(RuleSetReferenceId.parse(ref).get(0));
        for (Rule rule : otherRuleSet.getRules()) {
            excludedRulesCheck.remove(rule.getName());
            if (ruleSetReference.getExcludes().contains(rule.getName()) || rule.isDeprecated()) continue;
            RuleReference ruleReference = new RuleReference();
            ruleReference.setRuleSetReference(ruleSetReference);
            ruleReference.setRule(rule);
            ruleSetBuilder.addRuleIfNotExists(ruleReference);
            if (priority == null) continue;
            ruleReference.setPriority(RulePriority.valueOf(Integer.parseInt(priority)));
        }
        if (!excludedRulesCheck.isEmpty()) {
            throw new IllegalArgumentException("Unable to exclude rules " + excludedRulesCheck + "; perhaps the rule name is mispelled?");
        }
    }

    private void parseSingleRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Language language;
        Element ruleElement = (Element)ruleNode;
        if (StringUtil.isNotEmpty(ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleElement, ruleSetReferenceId.getRuleName())) {
            return;
        }
        String attribute = ruleElement.getAttribute("class");
        if (attribute == null || "".equals(attribute)) {
            throw new IllegalArgumentException("The 'class' field of rule can't be null, nor empty.");
        }
        Rule rule = (Rule)this.classLoader.loadClass(attribute).newInstance();
        rule.setName(ruleElement.getAttribute("name"));
        if (ruleElement.hasAttribute("language")) {
            String languageName = ruleElement.getAttribute("language");
            Language language2 = LanguageRegistry.findLanguageByTerseName(languageName);
            if (language2 == null) {
                throw new IllegalArgumentException("Unknown Language '" + languageName + FOR_RULE + rule.getName() + ", supported Languages are " + LanguageRegistry.commaSeparatedTerseNamesForLanguage(LanguageRegistry.findWithRuleSupport()));
            }
            rule.setLanguage(language2);
        }
        if ((language = rule.getLanguage()) == null) {
            throw new IllegalArgumentException("Rule " + rule.getName() + " does not have a Language; missing 'language' attribute?");
        }
        if (ruleElement.hasAttribute("minimumLanguageVersion")) {
            String minimumLanguageVersionName = ruleElement.getAttribute("minimumLanguageVersion");
            LanguageVersion minimumLanguageVersion = language.getVersion(minimumLanguageVersionName);
            if (minimumLanguageVersion == null) {
                throw new IllegalArgumentException("Unknown minimum Language Version '" + minimumLanguageVersionName + "' for Language '" + language.getTerseName() + FOR_RULE + rule.getName() + "; supported Language Versions are: " + LanguageRegistry.commaSeparatedTerseNamesForLanguageVersion(language.getVersions()));
            }
            rule.setMinimumLanguageVersion(minimumLanguageVersion);
        }
        if (ruleElement.hasAttribute("maximumLanguageVersion")) {
            String maximumLanguageVersionName = ruleElement.getAttribute("maximumLanguageVersion");
            LanguageVersion maximumLanguageVersion = language.getVersion(maximumLanguageVersionName);
            if (maximumLanguageVersion == null) {
                throw new IllegalArgumentException("Unknown maximum Language Version '" + maximumLanguageVersionName + "' for Language '" + language.getTerseName() + FOR_RULE + rule.getName() + "; supported Language Versions are: " + LanguageRegistry.commaSeparatedTerseNamesForLanguageVersion(language.getVersions()));
            }
            rule.setMaximumLanguageVersion(maximumLanguageVersion);
        }
        if (rule.getMinimumLanguageVersion() != null && rule.getMaximumLanguageVersion() != null) {
            throw new IllegalArgumentException("The minimum Language Version '" + rule.getMinimumLanguageVersion().getTerseName() + "' must be prior to the maximum Language Version '" + rule.getMaximumLanguageVersion().getTerseName() + FOR_RULE + rule.getName() + "; perhaps swap them around?");
        }
        String since = ruleElement.getAttribute("since");
        if (StringUtil.isNotEmpty(since)) {
            rule.setSince(since);
        }
        rule.setMessage(ruleElement.getAttribute(MESSAGE));
        rule.setRuleSetName(ruleSetBuilder.getName());
        rule.setExternalInfoUrl(ruleElement.getAttribute(EXTERNAL_INFO_URL));
        if (RuleSetFactory.hasAttributeSetTrue(ruleElement, "dfa")) {
            rule.setUsesDFA();
        }
        if (RuleSetFactory.hasAttributeSetTrue(ruleElement, "typeResolution")) {
            rule.setUsesTypeResolution();
        }
        NodeList nodeList = ruleElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName();
            if (DESCRIPTION.equals(nodeName)) {
                rule.setDescription(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if ("example".equals(nodeName)) {
                rule.addExample(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (PRIORITY.equals(nodeName)) {
                rule.setPriority(RulePriority.valueOf(Integer.parseInt(RuleSetFactory.parseTextNode(node).trim())));
                continue;
            }
            if ("properties".equals(nodeName)) {
                RuleSetFactory.parsePropertiesNode(rule, node);
                continue;
            }
            throw new IllegalArgumentException(UNEXPECTED_ELEMENT + nodeName + "> encountered as child of <rule> element for Rule " + rule.getName());
        }
        if (StringUtil.isNotEmpty(ruleSetReferenceId.getRuleName()) || rule.getPriority().compareTo(this.minimumPriority) <= 0) {
            ruleSetBuilder.addRule(rule);
        }
    }

    private static boolean hasAttributeSetTrue(Element element, String attributeId) {
        return element.hasAttribute(attributeId) && "true".equalsIgnoreCase(element.getAttribute(attributeId));
    }

    private void parseRuleReferenceNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode, String ref, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        Rule referencedRule;
        Element ruleElement = (Element)ruleNode;
        if (StringUtil.isNotEmpty(ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleElement, ruleSetReferenceId.getRuleName())) {
            return;
        }
        RuleSetFactory ruleSetFactory = new RuleSetFactory(this, this.warnDeprecated);
        boolean isSameRuleSet = false;
        RuleSetReferenceId otherRuleSetReferenceId = RuleSetReferenceId.parse(ref).get(0);
        if (!otherRuleSetReferenceId.isExternal() && this.containsRule(ruleSetReferenceId, otherRuleSetReferenceId.getRuleName())) {
            otherRuleSetReferenceId = new RuleSetReferenceId(ref, ruleSetReferenceId);
            isSameRuleSet = true;
        }
        if ((referencedRule = ruleSetFactory.createRule(otherRuleSetReferenceId, true)) == null) {
            throw new IllegalArgumentException("Unable to find referenced rule " + otherRuleSetReferenceId.getRuleName() + "; perhaps the rule name is mispelled?");
        }
        if (this.warnDeprecated && referencedRule.isDeprecated()) {
            if (referencedRule instanceof RuleReference) {
                RuleReference ruleReference = (RuleReference)referencedRule;
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Use Rule name " + ruleReference.getRuleSetReference().getRuleSetFileName() + "/" + ruleReference.getOriginalName() + " instead of the deprecated Rule name " + otherRuleSetReferenceId + ". Future versions of PMD will remove support for this deprecated Rule name usage.");
                }
            } else if (referencedRule instanceof MockRule) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Discontinue using Rule name " + otherRuleSetReferenceId + " as it has been removed from PMD and no longer functions." + " Future versions of PMD will remove support for this Rule.");
                }
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Discontinue using Rule name " + otherRuleSetReferenceId + " as it is scheduled for removal from PMD." + " Future versions of PMD will remove support for this Rule.");
            }
        }
        RuleSetReference ruleSetReference = new RuleSetReference();
        ruleSetReference.setAllRules(false);
        ruleSetReference.setRuleSetFileName(otherRuleSetReferenceId.getRuleSetFileName());
        RuleReference ruleReference = new RuleReference();
        ruleReference.setRuleSetReference(ruleSetReference);
        ruleReference.setRule(referencedRule);
        if (ruleElement.hasAttribute("deprecated")) {
            ruleReference.setDeprecated(Boolean.parseBoolean(ruleElement.getAttribute("deprecated")));
        }
        if (ruleElement.hasAttribute("name")) {
            ruleReference.setName(ruleElement.getAttribute("name"));
        }
        if (ruleElement.hasAttribute(MESSAGE)) {
            ruleReference.setMessage(ruleElement.getAttribute(MESSAGE));
        }
        if (ruleElement.hasAttribute(EXTERNAL_INFO_URL)) {
            ruleReference.setExternalInfoUrl(ruleElement.getAttribute(EXTERNAL_INFO_URL));
        }
        for (int i = 0; i < ruleElement.getChildNodes().getLength(); ++i) {
            Node node = ruleElement.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals(DESCRIPTION)) {
                ruleReference.setDescription(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("example")) {
                ruleReference.addExample(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals(PRIORITY)) {
                ruleReference.setPriority(RulePriority.valueOf(Integer.parseInt(RuleSetFactory.parseTextNode(node))));
                continue;
            }
            if (node.getNodeName().equals("properties")) {
                RuleSetFactory.parsePropertiesNode(ruleReference, node);
                continue;
            }
            throw new IllegalArgumentException(UNEXPECTED_ELEMENT + node.getNodeName() + "> encountered as child of <rule> element for Rule " + ruleReference.getName());
        }
        if (!(!StringUtil.isNotEmpty(ruleSetReferenceId.getRuleName()) && referencedRule.getPriority().compareTo(this.minimumPriority) > 0 || !withDeprecatedRuleReferences && isSameRuleSet && ruleReference.isDeprecated())) {
            ruleSetBuilder.addRuleReplaceIfExists(ruleReference);
        }
    }

    private boolean containsRule(RuleSetReferenceId ruleSetReferenceId, String ruleName) {
        boolean found = false;
        try (InputStream ruleSet = ruleSetReferenceId.getInputStream(this.classLoader);){
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(ruleSet);
            Element ruleSetElement = document.getDocumentElement();
            NodeList rules = ruleSetElement.getElementsByTagName("rule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                if (!rule.hasAttribute("name") || !rule.getAttribute("name").equals(ruleName)) continue;
                found = true;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return found;
    }

    private static boolean isElementNode(Node node, String name) {
        return node.getNodeType() == 1 && node.getNodeName().equals(name);
    }

    private static void parsePropertiesNode(Rule rule, Node propertiesNode) {
        for (int i = 0; i < propertiesNode.getChildNodes().getLength(); ++i) {
            Node node = propertiesNode.getChildNodes().item(i);
            if (!RuleSetFactory.isElementNode(node, "property")) continue;
            RuleSetFactory.parsePropertyNodeBR(rule, node);
        }
    }

    private static String valueFrom(Node parentNode) {
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!RuleSetFactory.isElementNode(node, "value")) continue;
            return RuleSetFactory.parseTextNode(node);
        }
        return null;
    }

    private static <T> void setValue(Rule rule, PropertyDescriptor<T> desc, String strValue) {
        T realValue = desc.valueFrom(strValue);
        rule.setProperty(desc, realValue);
    }

    private static void parsePropertyNodeBR(Rule rule, Node propertyNode) {
        Element propertyElement = (Element)propertyNode;
        String typeId = propertyElement.getAttribute("type");
        String strValue = propertyElement.getAttribute("value");
        if (StringUtil.isEmpty(strValue)) {
            strValue = RuleSetFactory.valueFrom(propertyElement);
        }
        if (StringUtil.isEmpty(typeId)) {
            String name = propertyElement.getAttribute("name");
            PropertyDescriptor<?> propertyDescriptor = rule.getPropertyDescriptor(name);
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException("Cannot set non-existant property '" + name + "' on Rule " + rule.getName());
            }
            RuleSetFactory.setValue(rule, propertyDescriptor, strValue);
            return;
        }
        PropertyDescriptorFactory pdFactory = PropertyDescriptorUtil.factoryFor(typeId);
        if (pdFactory == null) {
            throw new RuntimeException("No property descriptor factory for type: " + typeId);
        }
        Map<String, Boolean> valueKeys = pdFactory.expectedFields();
        HashMap<String, String> values = new HashMap<String, String>(valueKeys.size());
        for (Map.Entry<String, Boolean> entry : valueKeys.entrySet()) {
            String valueStr = propertyElement.getAttribute(entry.getKey());
            if (entry.getValue().booleanValue() && StringUtil.isEmpty(valueStr)) {
                System.out.println("Missing required value for: " + entry.getKey());
            }
            values.put(entry.getKey(), valueStr);
        }
        PropertyDescriptor<?> desc = pdFactory.createWith(values);
        PropertyDescriptorWrapper wrapper = new PropertyDescriptorWrapper(desc);
        rule.definePropertyDescriptor(wrapper);
        RuleSetFactory.setValue(rule, desc, strValue);
    }

    private static String parseTextNode(Node node) {
        int nodeCount = node.getChildNodes().getLength();
        if (nodeCount == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < nodeCount; ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 4 && childNode.getNodeType() != 3) continue;
            buffer.append(childNode.getNodeValue());
        }
        return buffer.toString();
    }

    private boolean isRuleName(Element ruleElement, String ruleName) {
        if (ruleElement.hasAttribute("name")) {
            return ruleElement.getAttribute("name").equals(ruleName);
        }
        if (ruleElement.hasAttribute("ref")) {
            RuleSetReferenceId ruleSetReferenceId = RuleSetReferenceId.parse(ruleElement.getAttribute("ref")).get(0);
            return ruleSetReferenceId.getRuleName() != null && ruleSetReferenceId.getRuleName().equals(ruleName);
        }
        return false;
    }
}

