/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.cache.AnalysisCache;
import net.sourceforge.pmd.cache.FileAnalysisCache;
import net.sourceforge.pmd.cache.NoopAnalysisCache;
import net.sourceforge.pmd.internal.util.AssertionUtil;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import org.apache.commons.lang3.StringUtils;

public class PMDConfiguration
extends AbstractConfiguration {
    public static final String DEFAULT_SUPPRESS_MARKER = "NOPMD";
    private String suppressMarker = "NOPMD";
    private int threads = Runtime.getRuntime().availableProcessors();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private LanguageVersionDiscoverer languageVersionDiscoverer = new LanguageVersionDiscoverer();
    private LanguageVersion forceLanguageVersion;
    private List<String> ruleSets = new ArrayList<String>();
    private RulePriority minimumPriority = RulePriority.LOW;
    private List<String> inputPaths = new ArrayList<String>();
    private String inputUri;
    private String inputFilePath;
    private String ignoreFilePath;
    private boolean ruleSetFactoryCompatibilityEnabled = true;
    private String reportFormat;
    private String reportFile;
    private boolean reportShortNames = false;
    private Properties reportProperties = new Properties();
    private boolean showSuppressedViolations = false;
    private boolean failOnViolation = true;
    private boolean stressTest;
    private boolean benchmark;
    private AnalysisCache analysisCache = new NoopAnalysisCache();
    private boolean ignoreIncrementalAnalysis;

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    @Deprecated
    public void prependClasspath(String classpath) throws IOException {
        try {
            this.prependAuxClasspath(classpath);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public void prependAuxClasspath(String classpath) {
        try {
            if (this.classLoader == null) {
                this.classLoader = PMDConfiguration.class.getClassLoader();
            }
            if (classpath != null) {
                this.classLoader = new ClasspathClassLoader(classpath, this.classLoader);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public LanguageVersionDiscoverer getLanguageVersionDiscoverer() {
        return this.languageVersionDiscoverer;
    }

    public LanguageVersion getForceLanguageVersion() {
        return this.forceLanguageVersion;
    }

    public boolean isForceLanguageVersion() {
        return this.forceLanguageVersion != null;
    }

    public void setForceLanguageVersion(LanguageVersion forceLanguageVersion) {
        this.forceLanguageVersion = forceLanguageVersion;
        this.languageVersionDiscoverer.setForcedVersion(forceLanguageVersion);
    }

    public void setDefaultLanguageVersion(LanguageVersion languageVersion) {
        Objects.requireNonNull(languageVersion);
        this.setDefaultLanguageVersions(Arrays.asList(languageVersion));
    }

    public void setDefaultLanguageVersions(List<LanguageVersion> languageVersions) {
        for (LanguageVersion languageVersion : languageVersions) {
            Objects.requireNonNull(languageVersion);
            this.languageVersionDiscoverer.setDefaultLanguageVersion(languageVersion);
        }
    }

    public LanguageVersion getLanguageVersionOfFile(String fileName) {
        LanguageVersion languageVersion = this.languageVersionDiscoverer.getDefaultLanguageVersionForFile(fileName);
        if (languageVersion == null) {
            languageVersion = this.languageVersionDiscoverer.getDefaultLanguageVersion(LanguageRegistry.getLanguage("Java"));
        }
        return languageVersion;
    }

    @Deprecated
    public String getRuleSets() {
        if (this.ruleSets.isEmpty()) {
            return null;
        }
        return StringUtils.join(this.ruleSets, (String)",");
    }

    public List<String> getRuleSetPaths() {
        return this.ruleSets;
    }

    public void setRuleSets(List<String> ruleSetPaths) {
        this.ruleSets = new ArrayList<String>(ruleSetPaths);
    }

    public void addRuleSet(String rulesetPath) {
        AssertionUtil.requireParamNotNull("rulesetPath", rulesetPath);
        this.ruleSets.add(rulesetPath);
    }

    @Deprecated
    public void setRuleSets(String ruleSets) {
        this.ruleSets = ruleSets == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(ruleSets.split(",")));
    }

    public RulePriority getMinimumPriority() {
        return this.minimumPriority;
    }

    public void setMinimumPriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
    }

    @Deprecated
    public String getInputPaths() {
        return this.inputPaths.isEmpty() ? null : StringUtils.join(this.inputPaths, (String)",");
    }

    public List<String> getAllInputPaths() {
        return Collections.unmodifiableList(this.inputPaths);
    }

    @Deprecated
    public void setInputPaths(String inputPaths) {
        ArrayList<String> paths = new ArrayList<String>();
        Collections.addAll(paths, inputPaths.split(","));
        this.inputPaths = paths;
    }

    public void setInputPaths(List<String> inputPaths) {
        this.inputPaths = new ArrayList<String>(inputPaths);
    }

    public void addInputPath(String inputPath) {
        Objects.requireNonNull(inputPath);
        this.inputPaths.add(inputPath);
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public String getIgnoreFilePath() {
        return this.ignoreFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    public void setIgnoreFilePath(String ignoreFilePath) {
        this.ignoreFilePath = ignoreFilePath;
    }

    public String getInputUri() {
        return this.inputUri;
    }

    public void setInputUri(String inputUri) {
        this.inputUri = inputUri;
    }

    public boolean isReportShortNames() {
        return this.reportShortNames;
    }

    public void setReportShortNames(boolean reportShortNames) {
        this.reportShortNames = reportShortNames;
    }

    public Renderer createRenderer() {
        return this.createRenderer(false);
    }

    public Renderer createRenderer(boolean withReportWriter) {
        Renderer renderer = RendererFactory.createRenderer(this.reportFormat, this.reportProperties);
        renderer.setShowSuppressedViolations(this.showSuppressedViolations);
        if (this.reportShortNames && this.inputPaths != null) {
            renderer.setUseShortNames(Collections.unmodifiableList(new ArrayList<String>(this.inputPaths)));
        }
        if (withReportWriter) {
            renderer.setReportFile(this.reportFile);
        }
        return renderer;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    public Properties getReportProperties() {
        return this.reportProperties;
    }

    public void setReportProperties(Properties reportProperties) {
        this.reportProperties = reportProperties;
    }

    public boolean isStressTest() {
        return this.stressTest;
    }

    public void setStressTest(boolean stressTest) {
        this.stressTest = stressTest;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public boolean isRuleSetFactoryCompatibilityEnabled() {
        return this.ruleSetFactoryCompatibilityEnabled;
    }

    public void setRuleSetFactoryCompatibilityEnabled(boolean ruleSetFactoryCompatibilityEnabled) {
        this.ruleSetFactoryCompatibilityEnabled = ruleSetFactoryCompatibilityEnabled;
    }

    public AnalysisCache getAnalysisCache() {
        if (this.analysisCache == null || this.isIgnoreIncrementalAnalysis() && !(this.analysisCache instanceof NoopAnalysisCache)) {
            this.setAnalysisCache(new NoopAnalysisCache());
        }
        return this.analysisCache;
    }

    public void setAnalysisCache(AnalysisCache cache) {
        this.analysisCache = cache == null ? new NoopAnalysisCache() : cache;
    }

    public void setAnalysisCacheLocation(String cacheLocation) {
        this.setAnalysisCache(cacheLocation == null ? new NoopAnalysisCache() : new FileAnalysisCache(new File(cacheLocation)));
    }

    public void setIgnoreIncrementalAnalysis(boolean noCache) {
        this.ignoreIncrementalAnalysis = noCache;
    }

    public boolean isIgnoreIncrementalAnalysis() {
        return this.ignoreIncrementalAnalysis;
    }
}

