/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.internal;

import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.metrics.impl.CycloMetric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public class CycloVisitor
extends JavaParserVisitorAdapter {
    protected final boolean considerBooleanPaths;
    protected final boolean considerAssert;
    private final JavaNode topNode;

    public CycloVisitor(MetricOptions options, JavaNode topNode) {
        this.considerBooleanPaths = !options.getOptions().contains((Object)CycloMetric.CycloOption.IGNORE_BOOLEAN_PATHS);
        this.considerAssert = options.getOptions().contains((Object)CycloMetric.CycloOption.CONSIDER_ASSERT);
        this.topNode = topNode;
    }

    @Override
    public final Object visit(JavaNode localNode, Object data) {
        return localNode.isFindBoundary() && !localNode.equals(this.topNode) ? data : super.visit(localNode, data);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getTestedExpression()));
        }
        for (ASTSwitchLabel label : node) {
            if (label.isDefault()) continue;
            if (this.considerBooleanPaths) {
                ((MutableInt)data).increment();
                continue;
            }
            if (node.jjtGetNumChildren() <= 1 + label.jjtGetChildIndex() || !(node.jjtGetChild(label.jjtGetChildIndex() + 1) instanceof ASTBlockStatement)) continue;
            ((MutableInt)data).increment();
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getGuardExpressionNode()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getGuardExpressionNode()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getGuardExpressionNode()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths && !node.isForeach()) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getGuardExpressionNode()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getGuardExpressionNode()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTCatchStatement node, Object data) {
        ((MutableInt)data).increment();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTThrowStatement node, Object data) {
        ((MutableInt)data).increment();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTAssertStatement node, Object data) {
        if (this.considerAssert) {
            ((MutableInt)data).add(2);
            if (this.considerBooleanPaths) {
                ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity(node.getGuardExpressionNode()));
            }
        }
        return super.visit(node, data);
    }
}

