/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaParserImpl;
import net.sourceforge.pmd.lang.java.ast.JavaParserImplTokenManager;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProperties;

public final class SyntacticJavaTokenizerFactory {
    private SyntacticJavaTokenizerFactory() {
    }

    public static TokenManager<JavaccToken> createTokenizer(CharStream cs) {
        JavaParserImpl parser;
        final ArrayList tokenList = new ArrayList();
        JavaParserImplTokenManager tokenManager = new JavaParserImplTokenManager(null, cs){

            @Override
            public JavaccToken getNextToken() {
                JavaccToken token = super.getNextToken();
                tokenList.add(token);
                return token;
            }
        };
        LanguageVersion latestVersion = JavaLanguageModule.getInstance().getLatestVersion();
        tokenManager.parser = parser = new JavaParserImpl(tokenManager);
        parser.setJdkVersion(JavaLanguageProperties.getInternalJdkVersion(latestVersion));
        parser.setPreview(JavaLanguageProperties.isPreviewEnabled(latestVersion));
        ASTCompilationUnit compilationUnit = parser.CompilationUnit();
        assert (compilationUnit != null);
        return new TokenManager<JavaccToken>(){
            Iterator<JavaccToken> iterator;
            {
                this.iterator = tokenList.iterator();
            }

            public JavaccToken getNextToken() {
                return this.iterator.next();
            }
        };
    }
}

