/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class JUnitTestsShouldIncludeAssertRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Set<String>> EXTRA_ASSERT_METHOD_NAMES = ((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"extraAssertMethodNames").desc("Extra valid assertion methods names")).map(Collectors.toSet()).emptyDefaultValue().build();

    public JUnitTestsShouldIncludeAssertRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(EXTRA_ASSERT_METHOD_NAMES);
    }

    public Object visit(ASTMethodDeclaration method, Object data) {
        ASTBlock body = method.getBody();
        Set extraAsserts = (Set)this.getProperty(EXTRA_ASSERT_METHOD_NAMES);
        if (body != null && TestFrameworksUtil.isTestMethod(method) && !TestFrameworksUtil.isExpectAnnotated(method) && body.descendants(ASTMethodCall.class).none(call -> TestFrameworksUtil.isProbableAssertCall(call) || extraAsserts.contains(call.getMethodName()))) {
            this.asCtx(data).addViolation((Node)method);
        }
        return data;
    }
}

