/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.javaflow.spi.ClassMatcher;
import org.apache.commons.javaflow.spi.ClassMatcherFileParser;
import org.apache.commons.javaflow.spi.ClassMatchers;
import org.apache.commons.javaflow.spi.VetoableResourceLoader;

public class ClasspathResourceLoader
implements VetoableResourceLoader {
    private final Reference<ClassLoader> classLoaderRef;

    public ClasspathResourceLoader(ClassLoader classLoader) {
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
    }

    @Override
    public boolean hasResource(String name) {
        ClassLoader classLoader = this.classLoaderRef.get();
        return null != classLoader && null != classLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) throws IOException {
        ClassLoader classLoader = this.classLoaderRef.get();
        if (null == classLoader) {
            throw new IOException("Underlying class loader was evicted from memory, this resource loader is unusable");
        }
        InputStream result = classLoader.getResourceAsStream(name);
        if (null == result) {
            throw new IOException("Unable to find resource " + name);
        }
        return result;
    }

    @Override
    public ClassMatcher createVeto() throws IOException {
        ArrayList<ClassMatcher> matchers = new ArrayList<ClassMatcher>();
        ClassLoader classLoader = this.classLoaderRef.get();
        if (null == classLoader) {
            return ClassMatchers.MATCH_NONE;
        }
        Enumeration<URL> allResources = classLoader.getResources("META-INF/net.tascalate.javaflow.veto.cmf");
        ClassMatcherFileParser parser = new ClassMatcherFileParser();
        while (allResources.hasMoreElements()) {
            URL resource = allResources.nextElement();
            ClassMatcher matcher = parser.parse(resource);
            if (null == matcher || ClassMatchers.MATCH_NONE == matcher) continue;
            matchers.add(matcher);
        }
        return matchers.isEmpty() ? ClassMatchers.MATCH_NONE : ClassMatchers.whenAny(matchers);
    }

    public static boolean isClassLoaderParent(ClassLoader classLoader, ClassLoader maybeParent) {
        ClassLoader cl = classLoader;
        do {
            if (maybeParent != (cl = cl.getParent())) continue;
            return true;
        } while (cl != null);
        return false;
    }
}

