/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.HijriCalendar;

final class SPX1
implements Externalizable {
    private static final int HIJRI = 1;
    private static final long serialVersionUID = 1L;
    private transient Object obj;

    public SPX1() {
    }

    SPX1(Object object) {
        this.obj = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        HijriCalendar hijriCalendar = (HijriCalendar)this.obj;
        objectOutput.writeUTF(hijriCalendar.getVariant());
        objectOutput.writeUTF(HijriCalendar.getVersion(hijriCalendar.getVariant()));
        objectOutput.writeInt(hijriCalendar.getYear());
        objectOutput.writeByte(hijriCalendar.getMonth().getValue());
        objectOutput.writeByte(hijriCalendar.getDayOfMonth());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw new InvalidObjectException("Unknown calendar type.");
        }
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        if (!HijriCalendar.getVersion(string).equals(string2)) {
            throw new InvalidObjectException("Hijri calendar object with different data version not supported: " + string + "/" + string2);
        }
        int n = objectInput.readInt();
        byte by2 = objectInput.readByte();
        byte by3 = objectInput.readByte();
        this.obj = HijriCalendar.of(string, n, (int)by2, (int)by3);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

