/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.PlainDate;
import net.time4j.calendar.HistoricCalendar;
import net.time4j.engine.EpochDays;

final class SPX11
implements Externalizable {
    private static final int HISTORIC = 11;
    private static final long serialVersionUID = 1L;
    private transient Object obj;

    public SPX11() {
    }

    SPX11(Object object) {
        this.obj = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(11);
        HistoricCalendar historicCalendar = (HistoricCalendar)this.obj;
        objectOutput.writeUTF(historicCalendar.getHistory().getVariant());
        objectOutput.writeLong(historicCalendar.get(PlainDate.COMPONENT).getDaysSinceEpochUTC());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 11) {
            throw new InvalidObjectException("Unknown calendar type.");
        }
        String string = objectInput.readUTF();
        long l = objectInput.readLong();
        PlainDate plainDate = PlainDate.of(l, EpochDays.UTC);
        this.obj = plainDate.transform(HistoricCalendar.family(), string);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

