/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.internal;

import java.util.Locale;

public class FormatUtils {
    private FormatUtils() {
    }

    public static String getRegion(Locale locale) {
        String string;
        String string2 = locale.getUnicodeLocaleType("rg");
        if (string2 != null && string2.length() == 6 && (string = string2.toUpperCase(Locale.US)).endsWith("ZZZZ")) {
            return string.substring(0, 2);
        }
        return locale.getCountry();
    }

    public static boolean useDefaultWeekmodel(Locale locale) {
        String string = locale.getUnicodeLocaleType("fw");
        if (string != null && FormatUtils.getWeekdayISO(string) != 0) {
            return false;
        }
        return FormatUtils.getRegion(locale).isEmpty();
    }

    public static String removeZones(String string) {
        int n;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c == '\'') {
                if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                    stringBuilder.append(c);
                    ++n;
                } else {
                    bl = !bl;
                }
                stringBuilder.append(c);
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            if (c == 'z' || c == 'Z' || c == 'v' || c == 'V' || c == 'x' || c == 'X') continue;
            stringBuilder.append(c);
        }
        for (n = 0; n < stringBuilder.length(); ++n) {
            n2 = stringBuilder.charAt(n);
            if (n2 == 32 && n + 1 < stringBuilder.length() && stringBuilder.charAt(n + 1) == ' ') {
                stringBuilder.deleteCharAt(n);
                --n;
                continue;
            }
            if (n2 != 91 && n2 != 93 && n2 != 40 && n2 != 41) continue;
            stringBuilder.deleteCharAt(n);
            --n;
        }
        String string2 = stringBuilder.toString().trim();
        if (string2.endsWith(" '")) {
            string2 = string2.substring(0, string2.length() - 2) + "'";
        } else if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String replaceSymbol(String string, char c, char c2) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (c3 == '\'') {
                if (i + 1 < n && string.charAt(i + 1) == '\'') {
                    stringBuilder.append(c3);
                    ++i;
                } else {
                    bl = !bl;
                }
                stringBuilder.append(c3);
                continue;
            }
            if (bl) {
                stringBuilder.append(c3);
                continue;
            }
            if (c3 == c) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString().trim();
    }

    private static int getWeekdayISO(String string) {
        switch (string) {
            case "mon": {
                return 1;
            }
            case "tue": {
                return 2;
            }
            case "wed": {
                return 3;
            }
            case "thu": {
                return 4;
            }
            case "fri": {
                return 5;
            }
            case "sat": {
                return 6;
            }
            case "sun": {
                return 7;
            }
        }
        return 0;
    }
}

