/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.format.internal.FormatUtils;

public enum HourCycle {
    H12('h', false),
    H23('H', false),
    H11('K', false),
    H24('k', false),
    H12_B('h', true),
    H11_B('K', true);

    private static final Set<String> REGIONS_FLEX_DP;
    private static final Set<String> REGIONS_12H;
    private static final Set<String> REGIONS_24H;
    private final transient char formatChar;
    private final transient boolean usingFlexDP;

    private HourCycle(char c, boolean bl) {
        this.formatChar = c;
        this.usingFlexDP = bl;
    }

    public static HourCycle of(Locale locale) {
        boolean bl;
        String string = locale.getUnicodeLocaleType("hc");
        String string2 = locale.getLanguage();
        String string3 = FormatUtils.getRegion(locale);
        boolean bl2 = false;
        if (string == null) {
            bl = "CA".equals(string3) && "fr".equals(string2) ? false : (REGIONS_12H.contains(string3) ? true : (REGIONS_24H.contains(string3) ? false : "en".equals(string2) || "ar".equals(string2)));
        } else {
            switch (string) {
                case "h12": {
                    bl = true;
                    break;
                }
                case "h23": {
                    bl = false;
                    break;
                }
                case "h11": {
                    bl = true;
                    bl2 = true;
                    break;
                }
                case "h24": {
                    bl = false;
                    bl2 = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid hc-value found: " + string);
                }
            }
        }
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = REGIONS_FLEX_DP.contains(string2 + "_" + string3) || REGIONS_FLEX_DP.contains(string3);
            if (bl2) {
                return bl3 ? H11_B : H11;
            }
            return bl3 ? H12_B : H12;
        }
        return bl2 ? H24 : H23;
    }

    public boolean isHalfdayCycle() {
        return this.formatChar == 'h' || this.formatChar == 'K';
    }

    public boolean isZeroBased() {
        return this.formatChar == 'H' || this.formatChar == 'K';
    }

    public boolean isUsingFlexibleDayperiods() {
        return this.usingFlexDP;
    }

    private static void fill(Set<String> set, String string) {
        set.addAll(Arrays.asList(string.split(" ")));
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        HourCycle.fill(hashSet, "AF LA");
        HourCycle.fill(hashSet, "AD AM AO AT AW BE BF BJ BL BR CG CI CV DE EE FR GA GF GN GP GW HR IL IT KZ MC MD MF MQ MZ NC NL PM PT RE RO SI SR ST TG TR WF YT");
        HourCycle.fill(hashSet, "AZ BA BG CH GE LI ME RS UA UZ XK");
        HourCycle.fill(hashSet, "BO EC ES GQ PE");
        HourCycle.fill(hashSet, "LV TL zu_ZA");
        HourCycle.fill(hashSet, "CD IR");
        HourCycle.fill(hashSet, "KE MM TZ UG");
        HourCycle.fill(hashSet, "BN MY");
        HourCycle.fill(hashSet, "hi_IN kn_IN ml_IN te_IN");
        HourCycle.fill(hashSet, "KH ta_IN");
        HourCycle.fill(hashSet, "CN HK MO TW ET gu_IN mr_IN pa_IN");
        REGIONS_FLEX_DP = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        HourCycle.fill(hashSet2, "AS BT DJ ER GH IN LS PG PW SO TO VU WS");
        HourCycle.fill(hashSet2, "CY GR");
        HourCycle.fill(hashSet2, "AL TD");
        HourCycle.fill(hashSet2, "CO DO KP KR NA PA PR VE");
        HourCycle.fill(hashSet2, "AG AU BB BM BS CA DM FJ FM GD GM GU GY JM KI KN KY LC LR MH MP MW NZ SB SG SL SS SZ TC TT UM US VC VG VI ZM");
        HourCycle.fill(hashSet2, "BD PK");
        HourCycle.fill(hashSet2, "AE BH DZ EG EH IQ JO KW LB LY MR OM PH PS QA SA SD SY TN YE");
        HourCycle.fill(hashSet2, "BN KH MY");
        HourCycle.fill(hashSet2, "CN HK MO TW ET");
        REGIONS_12H = Collections.unmodifiableSet(hashSet2);
        HashSet<String> hashSet3 = new HashSet<String>();
        HourCycle.fill(hashSet3, "AX BQ CP CZ DK FI ID IS ML NE RU SE SJ SK");
        HourCycle.fill(hashSet3, "AC AI BW BZ CC CK CX DG FK GB GG GI IE IM IO JE LT MK MN MS NF NG NR NU PN SH SX TA ZA");
        HourCycle.fill(hashSet3, "CF CM LU NP PF SC SM SN TF VA");
        HourCycle.fill(hashSet3, "AR CL CR CU EA GT HN IC KG KM LK MA MX NI PY SV UY");
        HourCycle.fill(hashSet3, "AF JP LA");
        HourCycle.fill(hashSet3, "AD AM AO AT AW BE BF BJ BL BR CG CI CV DE EE FR GA GF GN GP GW HR IL IT KZ MC MD MF MQ MZ NC NL PM PT RE RO SI SR ST TG TR WF YT");
        HourCycle.fill(hashSet3, "AZ BA BG CH GE LI ME RS UA UZ XK");
        HourCycle.fill(hashSet3, "BO EC ES GQ PE");
        HourCycle.fill(hashSet3, "CD IR LV TL");
        HourCycle.fill(hashSet3, "KE MM TZ UG");
        REGIONS_24H = Collections.unmodifiableSet(hashSet3);
    }
}

