/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.List;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.SPX;
import net.time4j.tz.SimpleUT;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.TransitionModel;

final class HistorizedTimezone
extends Timezone {
    private static final long serialVersionUID = 1738909257417361021L;
    private final transient TZID id;
    private final transient TransitionHistory history;
    private final transient TransitionStrategy strategy;

    HistorizedTimezone(TZID tZID, TransitionHistory transitionHistory) {
        this(tZID, transitionHistory, Timezone.DEFAULT_CONFLICT_STRATEGY);
    }

    HistorizedTimezone(TZID tZID, TransitionHistory transitionHistory, TransitionStrategy transitionStrategy) {
        if (tZID == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        if (tZID instanceof ZonalOffset && !transitionHistory.isEmpty()) {
            throw new IllegalArgumentException("Fixed zonal offset can't be combined with offset transitions: " + tZID.canonical());
        }
        if (transitionHistory == null) {
            throw new NullPointerException("Missing timezone history.");
        }
        if (transitionStrategy == null) {
            throw new NullPointerException("Missing transition strategy.");
        }
        this.id = tZID;
        this.history = transitionHistory;
        this.strategy = transitionStrategy;
    }

    @Override
    public TZID getID() {
        return this.id;
    }

    @Override
    public ZonalOffset getOffset(UnixTime unixTime) {
        ZonalTransition zonalTransition = this.history.getStartTransition(unixTime);
        return zonalTransition == null ? this.history.getInitialOffset() : ZonalOffset.ofTotalSeconds(zonalTransition.getTotalOffset());
    }

    @Override
    public ZonalOffset getRawOffset(UnixTime unixTime) {
        ZonalTransition zonalTransition = this.history.getStartTransition(unixTime);
        return zonalTransition == null ? this.history.getInitialOffset() : ZonalOffset.ofTotalSeconds(zonalTransition.getRawOffset());
    }

    @Override
    public ZonalOffset getExtraOffset(UnixTime unixTime) {
        ZonalTransition zonalTransition = this.history.getStartTransition(unixTime);
        return zonalTransition == null ? ZonalOffset.UTC : ZonalOffset.ofTotalSeconds(zonalTransition.getExtraOffset());
    }

    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime) {
        List<ZonalOffset> list = this.history.getValidOffsets(gregorianDate, wallTime);
        if (list.size() == 1) {
            return list.get(0);
        }
        ZonalTransition zonalTransition = this.history.getConflictTransition(gregorianDate, wallTime);
        return ZonalOffset.ofTotalSeconds(zonalTransition.getTotalOffset());
    }

    @Override
    public boolean isInvalid(GregorianDate gregorianDate, WallTime wallTime) {
        ZonalTransition zonalTransition = this.history.getConflictTransition(gregorianDate, wallTime);
        return zonalTransition != null && zonalTransition.isGap();
    }

    @Override
    public boolean isDaylightSaving(UnixTime unixTime) {
        Object object;
        ZonalTransition zonalTransition = this.history.getStartTransition(unixTime);
        if (zonalTransition == null) {
            return false;
        }
        int n = zonalTransition.getExtraOffset();
        if (n > 0) {
            return true;
        }
        if (n < 0) {
            return false;
        }
        if (this.history instanceof TransitionModel && !((TransitionModel)(object = (TransitionModel)this.history)).hasNegativeDST()) {
            return false;
        }
        object = SimpleUT.previousTime(zonalTransition.getPosixTime(), 0);
        ZonalTransition zonalTransition2 = this.history.getStartTransition((UnixTime)object);
        if (zonalTransition2 == null) {
            return false;
        }
        if (zonalTransition2.getRawOffset() == zonalTransition.getRawOffset()) {
            return zonalTransition2.getExtraOffset() < 0;
        }
        return this.isDaylightSaving((UnixTime)object);
    }

    @Override
    public boolean isFixed() {
        return this.history.isEmpty();
    }

    @Override
    public TransitionHistory getHistory() {
        return this.history;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HistorizedTimezone) {
            HistorizedTimezone historizedTimezone = (HistorizedTimezone)object;
            return this.id.canonical().equals(historizedTimezone.id.canonical()) && this.history.equals(historizedTimezone.history) && this.strategy.equals(historizedTimezone.strategy);
        }
        return false;
    }

    public int hashCode() {
        return this.id.canonical().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(this.id.canonical());
        stringBuilder.append(",history={");
        stringBuilder.append(this.history);
        stringBuilder.append("},strategy=");
        stringBuilder.append(this.strategy);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public TransitionStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public Timezone with(TransitionStrategy transitionStrategy) {
        if (this.strategy == transitionStrategy) {
            return this;
        }
        return new HistorizedTimezone(this.id, this.history, transitionStrategy);
    }

    private Object writeReplace() {
        return new SPX(this, 14);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

