/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.vidageek.mirror.provider.ProxyReflectionProvider;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.proxy.dsl.MethodInterceptor;
import net.vidageek.mirror.proxy.dsl.ProxyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyHandler<T>
implements ProxyHandler<T> {
    private Class<?> baseClass = Object.class;
    private final List<Class<?>> interfaces = new ArrayList();
    private final ReflectionProvider provider;

    public DefaultProxyHandler(ReflectionProvider provider, Class<?>[] classes) {
        this.provider = provider;
        this.extractBaseClassAndInterfaces(classes);
    }

    private void extractBaseClassAndInterfaces(Class<?>[] classes) {
        boolean baseClassAlreadyFound = false;
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) {
                this.interfaces.add(clazz);
                continue;
            }
            if (!baseClassAlreadyFound) {
                if (Modifier.isFinal(clazz.getModifiers())) {
                    throw new IllegalArgumentException("Cannot proxify final class " + clazz.getName());
                }
                baseClassAlreadyFound = true;
                this.baseClass = clazz;
                continue;
            }
            throw new IllegalArgumentException("Cannot proxify more than one concrete/abstract class");
        }
    }

    @Override
    public T interceptingWith(MethodInterceptor ... interceptors) {
        if (interceptors == null || interceptors.length == 0) {
            throw new IllegalArgumentException("interceptors cannot be null or empty");
        }
        ProxyReflectionProvider proxyReflectionProvider = this.provider.getProxyReflectionProvider(this.baseClass, this.interfaces, interceptors);
        return (T)proxyReflectionProvider.createProxy();
    }
}

