/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.vidageek.mirror.list.dsl.Mapper;
import net.vidageek.mirror.list.dsl.Matcher;
import net.vidageek.mirror.list.dsl.MirrorList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BackedMirrorList<T>
implements MirrorList<T> {
    private final List<T> list;

    public BackedMirrorList(List<T> list) {
        this.list = Collections.unmodifiableList(list);
    }

    @Override
    public MirrorList<T> matching(Matcher<T> matcher) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (T element : this.list) {
            if (!matcher.accepts(element)) continue;
            filteredList.add(element);
        }
        return new BackedMirrorList(filteredList);
    }

    @Override
    public <E> MirrorList<E> mappingTo(Mapper<T, E> mapper) {
        ArrayList<E> mappedList = new ArrayList<E>();
        for (T element : this.list) {
            mappedList.add(mapper.map(element));
        }
        return new BackedMirrorList(mappedList);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public boolean add(T o) {
        return this.list.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.list).equals(o);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }
}

