/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.matcher;

import java.util.HashMap;
import java.util.Map;
import net.vidageek.mirror.matcher.MatchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassArrayMatcher {
    private final Class<?>[] baseClasses;
    private static Map<Class<?>, Class<?>> primitiveToWrapper = new HashMap();

    public ClassArrayMatcher(Class<?> ... baseClasses) {
        if (baseClasses == null) {
            throw new IllegalArgumentException("argument baseClasses cannot be null.");
        }
        this.baseClasses = baseClasses;
    }

    public MatchType match(Class<?> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException("argument classes cannot be null.");
        }
        if (this.baseClasses.length != classes.length) {
            return MatchType.DONT_MATCH;
        }
        if (this.isPerfectMatch(classes)) {
            return MatchType.PERFECT;
        }
        if (this.isMatch(classes)) {
            return MatchType.MATCH;
        }
        return MatchType.DONT_MATCH;
    }

    private boolean isMatch(Class<?>[] classes) {
        boolean isMatch = true;
        for (int i = 0; i < this.baseClasses.length; ++i) {
            if (this.areClassesAssignable(classes[i], this.baseClasses[i])) continue;
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private boolean isPerfectMatch(Class<?>[] classes) {
        boolean isPerfect = true;
        for (int i = 0; i < this.baseClasses.length; ++i) {
            if (this.areClassesEqual(this.baseClasses[i], classes[i])) continue;
            isPerfect = false;
            break;
        }
        return isPerfect;
    }

    private boolean areClassesAssignable(Class<?> c1, Class<?> c2) {
        if (!(c1.isPrimitive() ^ c2.isPrimitive())) {
            return c1.isAssignableFrom(c2);
        }
        if (c1.isPrimitive()) {
            return primitiveToWrapper.get(c1).isAssignableFrom(c2);
        }
        return primitiveToWrapper.get(c2).isAssignableFrom(c1);
    }

    private boolean areClassesEqual(Class<?> c1, Class<?> c2) {
        if (!(c1.isPrimitive() ^ c2.isPrimitive())) {
            return c1.equals(c2);
        }
        if (c1.isPrimitive()) {
            return primitiveToWrapper.get(c1).equals(c2);
        }
        return primitiveToWrapper.get(c2).equals(c1);
    }

    static {
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
    }
}

