/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.dsl.AllMethodAnnotationsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultAllMethodAnnotationsHandler
implements AllMethodAnnotationsHandler {
    private final Class<?> clazz;
    private final String methodName;
    private final ReflectionProvider provider;

    public DefaultAllMethodAnnotationsHandler(ReflectionProvider provider, Class<?> clazz, String methodName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz cannot be null.");
        }
        if (methodName == null || methodName.trim().length() == 0) {
            throw new IllegalArgumentException("Argument methodName cannot be null or blank.");
        }
        this.provider = provider;
        this.clazz = clazz;
        this.methodName = methodName.trim();
    }

    @Override
    public List<Annotation> withoutArgs() {
        return this.withArgs(new Class[0]);
    }

    @Override
    public List<Annotation> withArgs(Class<?> ... classes) {
        Method method = new Mirror(this.provider).on(this.clazz).reflect().method(this.methodName).withArgs(classes);
        if (method == null) {
            throw new IllegalArgumentException("could not find method that matched " + Arrays.asList(classes));
        }
        return this.provider.getAnnotatedElementReflectionProvider(method).getAnnotations();
    }
}

