/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.vidageek.mirror.list.BackedMirrorList;
import net.vidageek.mirror.list.dsl.Matcher;
import net.vidageek.mirror.list.dsl.MirrorList;
import net.vidageek.mirror.matcher.GetterMatcher;
import net.vidageek.mirror.matcher.SetterMatcher;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.DefaultAllAnnotationsHandler;
import net.vidageek.mirror.reflect.dsl.AllAnnotationsHandler;
import net.vidageek.mirror.reflect.dsl.AllReflectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultAllReflectionHandler<T>
implements AllReflectionHandler<T> {
    private final Class<T> clazz;
    private final ReflectionProvider provider;

    public DefaultAllReflectionHandler(ReflectionProvider provider, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.provider = provider;
        this.clazz = clazz;
    }

    @Override
    public MirrorList<Field> fields() {
        return new BackedMirrorList<Field>(this.provider.getClassReflectionProvider(this.clazz).reflectAllFields());
    }

    @Override
    public MirrorList<Method> methods() {
        return new BackedMirrorList<Method>(this.provider.getClassReflectionProvider(this.clazz).reflectAllMethods());
    }

    @Override
    public MirrorList<Constructor<T>> constructors() {
        return new BackedMirrorList<Constructor<T>>(this.provider.getClassReflectionProvider(this.clazz).reflectAllConstructors());
    }

    @Override
    public AllAnnotationsHandler annotations() {
        return new DefaultAllAnnotationsHandler(this.provider, this.clazz);
    }

    @Override
    public MirrorList<Method> setters() {
        return this.methods().matching(new SetterMatcher());
    }

    @Override
    public MirrorList<Method> getters() {
        return this.methods().matching(new GetterMatcher());
    }

    @Override
    public List<Field> fieldsMatching(Matcher<Field> matcher) {
        return this.fields().matching(matcher);
    }

    @Override
    public List<Method> methodsMatching(Matcher<Method> matcher) {
        return this.methods().matching(matcher);
    }

    @Override
    public List<Constructor<T>> constructorsMatching(Matcher<Constructor<T>> matcher) {
        return this.constructors().matching(matcher);
    }

    @Override
    public List<Annotation> annotationsMatching(Matcher<Annotation> matcher) {
        return new BackedMirrorList<Annotation>(this.annotations().atClass()).matching(matcher);
    }
}

