/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.DefaultMethodReflector;
import net.vidageek.mirror.reflect.dsl.MethodAnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultMethodAnnotationHandler<T extends Annotation>
implements MethodAnnotationHandler<T> {
    private final Class<?> clazz;
    private final String methodName;
    private final Class<T> annotation;
    private final ReflectionProvider provider;

    public DefaultMethodAnnotationHandler(ReflectionProvider provider, Class<?> clazz, String methodName, Class<T> annotation) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz cannot be null.");
        }
        if (methodName == null || methodName.trim().length() == 0) {
            throw new IllegalArgumentException("Argument fieldName cannot be null or empty.");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Argument annotation cannot be null.");
        }
        this.provider = provider;
        this.clazz = clazz;
        this.methodName = methodName.trim();
        this.annotation = annotation;
    }

    @Override
    public T withArgs(Class<?> ... classes) {
        Method method = new DefaultMethodReflector(this.provider, this.methodName, this.clazz).withArgs(classes);
        if (method == null) {
            throw new IllegalArgumentException("could not find method matching argument list " + Arrays.asList(classes));
        }
        return this.provider.getAnnotatedElementReflectionProvider(method).getAnnotation(this.annotation);
    }

    @Override
    public T withoutArgs() {
        return this.withArgs(new Class[0]);
    }
}

